"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizableCollapseButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _amsterdam = require("../../themes/amsterdam");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "fuwsll-euiResizableCollapseButton",
  styles: "z-index:2;position:absolute;&:focus{animation:none;};label:euiResizableCollapseButton;"
} : {
  name: "fuwsll-euiResizableCollapseButton",
  styles: "z-index:2;position:absolute;&:focus{animation:none;};label:euiResizableCollapseButton;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiResizableCollapseButtonStyles = function euiResizableCollapseButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var buttonSize = euiTheme.size.l;
  var centeringOffset = (0, _global_styling.mathWithUnits)(buttonSize, function (x) {
    return x / -2;
  }); // Use negative margins instead of transforms to avoid having to override EuiButtonIcon's CSS
  var buttonOffset = euiTheme.size.base;
  return {
    euiResizableCollapseButton: _ref,
    collapsible: {
      collapsible: /*#__PURE__*/(0, _react.css)("background:", euiTheme.colors.emptyShade, ";", (0, _amsterdam.euiShadowXSmall)(euiThemeContext), " &:focus{", (0, _amsterdam.euiSlightShadowHover)(euiThemeContext), ";};label:collapsible;"),
      horizontal: {
        after: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.logicalCSS)('margin-right', centeringOffset), ";;label:after;"),
        before: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('margin-left', centeringOffset), ";;label:before;"),
        middle: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', '50%'), " ", (0, _global_styling.logicalCSS)('margin-top', centeringOffset), ";;label:middle;"),
        top: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('margin-top', buttonOffset), ";;label:top;"),
        bottom: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('margin-bottom', buttonOffset), ";;label:bottom;"),
        // `left/right` aren't valid positions for the horizontal direction,
        // so we're using getters to fall back to the `middle` CSS
        get left() {
          return this.middle;
        },
        get right() {
          return this.middle;
        }
      },
      vertical: {
        after: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', '100%'), " ", (0, _global_styling.logicalCSS)('margin-top', centeringOffset), ";;label:after;"),
        before: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('bottom', '100%'), " ", (0, _global_styling.logicalCSS)('margin-bottom', centeringOffset), ";;label:before;"),
        middle: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', '50%'), " ", (0, _global_styling.logicalCSS)('margin-left', centeringOffset), ";;label:middle;"),
        left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('margin-left', buttonOffset), ";;label:left;"),
        right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.logicalCSS)('margin-right', buttonOffset), ";;label:right;"),
        // `top/bottom` aren't valid positions for the horizontal direction,
        // so we're using getters to fall back to the `middle` CSS
        get top() {
          return this.middle;
        },
        get bottom() {
          return this.middle;
        }
      }
    },
    collapsed: {
      // When collapsed, the button itself is the full collapsed area
      // and we use flex to align the icon within
      collapsed: /*#__PURE__*/(0, _react.css)("border-radius:0;", (0, _global_styling.logicalCSS)('top', 0), ";;label:collapsed;"),
      horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), ";;label:horizontal;"),
      vertical: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:vertical;"),
      horizontalPositions: {
        top: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', buttonOffset), " align-items:flex-start;;label:top;"),
        bottom: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-bottom', buttonOffset), " align-items:flex-end;;label:bottom;"),
        middle: /*#__PURE__*/(0, _react.css)(";label:middle;"),
        left: /*#__PURE__*/(0, _react.css)(";label:left;"),
        right: /*#__PURE__*/(0, _react.css)(";label:right;")
      },
      verticalPositions: {
        left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-left', buttonOffset), " justify-content:flex-start;;label:left;"),
        right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-right', buttonOffset), " justify-content:flex-end;;label:right;"),
        middle: /*#__PURE__*/(0, _react.css)(";label:middle;"),
        top: /*#__PURE__*/(0, _react.css)(";label:top;"),
        bottom: /*#__PURE__*/(0, _react.css)(";label:bottom;")
      }
    }
  };
};
exports.euiResizableCollapseButtonStyles = euiResizableCollapseButtonStyles;