"use strict";

var _react = _interopRequireDefault(require("react"));
var _progress = require("./progress");
var _spacer = require("../spacer");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); } /*
                                                                                                                                                                                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                     */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var ProgressCommonProps = {
  color: 'success',
  max: 100
};
var ProgressBars = function ProgressBars() {
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", {
    "data-test-subj": "cy-progress-1"
  }, (0, _react2.jsx)(_progress.EuiProgress, _extends({
    valueText: true,
    size: "xs",
    value: 0
  }, ProgressCommonProps))), (0, _react2.jsx)("div", {
    "data-test-subj": "cy-progress-2"
  }, (0, _react2.jsx)(_progress.EuiProgress, _extends({
    valueText: true,
    size: "s",
    value: 33
  }, ProgressCommonProps))), (0, _react2.jsx)("div", {
    "data-test-subj": "cy-progress-3"
  }, (0, _react2.jsx)(_progress.EuiProgress, _extends({
    valueText: true,
    size: "m",
    value: 66
  }, ProgressCommonProps))), (0, _react2.jsx)("div", {
    "data-test-subj": "cy-progress-4"
  }, (0, _react2.jsx)(_progress.EuiProgress, _extends({
    valueText: true,
    size: "l",
    value: 100
  }, ProgressCommonProps))), (0, _react2.jsx)("div", {
    "data-test-subj": "cy-progress-5"
  }, (0, _react2.jsx)(_progress.EuiProgress, _extends({
    valueText: true,
    label: "Basic percentage",
    size: "l",
    value: 100
  }, ProgressCommonProps))), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)("div", {
    "data-test-subj": "cy-progress-infinite"
  }, (0, _react2.jsx)(_progress.EuiProgress, {
    valueText: true,
    size: "l",
    color: "success"
  })));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(ProgressBars, null));
  cy.get('div[data-test-subj="cy-progress-1"]').should('exist');
});
describe('EuiProgress', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('displays correct progress values and labels', function () {
      cy.get('div[data-test-subj="cy-progress-1"] span.euiProgress__valueText').contains('0');
      cy.get('div[data-test-subj="cy-progress-2"] span.euiProgress__valueText').contains('33');
      cy.get('div[data-test-subj="cy-progress-3"] span.euiProgress__valueText').contains('66');
      cy.get('div[data-test-subj="cy-progress-4"] span.euiProgress__valueText').contains('100');
      cy.get('div[data-test-subj="cy-progress-5"] span.euiProgress__label').contains('Basic percentage');
      cy.get('div[data-test-subj="cy-progress-5"] span.euiProgress__valueText').contains('100');
      cy.get('div[data-test-subj="cy-progress-infinite"] span.euiProgress__valueText').should('not.exist');
    });
  });
});