"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeTooltipValueStyles = exports.euiRangeTooltipStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _range = require("./range.styles");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeTooltipStyles = function euiRangeTooltipStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    // Base
    euiRangeTooltip: /*#__PURE__*/(0, _react.css)("display:block;position:absolute;inset-inline-start:0;inset-block:0;inline-size:calc(100% - ", range.thumbWidth, ");margin-inline-start:", (0, _global_styling.mathWithUnits)(range.thumbWidth, function (x) {
      return x / 2;
    }), ";pointer-events:none;z-index:", range.thumbZIndex, ";;label:euiRangeTooltip;")
  };
};
exports.euiRangeTooltipStyles = euiRangeTooltipStyles;
var euiToolTipBackgroundColor = function euiToolTipBackgroundColor(euiTheme, colorMode) {
  return colorMode === _services.COLOR_MODES_STANDARD.dark ? (0, _services.shade)(euiTheme.colors.emptyShade, 1) : (0, _services.tint)(euiTheme.colors.fullShade, 0.25);
};
var euiRangeTooltipValueStyles = function euiRangeTooltipValueStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var arrowSize = euiTheme.size.m;
  var arrowSizeInt = parseInt(arrowSize, 10);
  var arrowMinusSize = "".concat((arrowSizeInt / 2 - 1) * -1, "px"); // Shift arrow 1px more than half its size to account for border radius

  return {
    euiRangeTooltip__value: /*#__PURE__*/(0, _react.css)("position:absolute;inset-block-start:50%;max-inline-size:", (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 16;
    }), ";padding-block:", euiTheme.size.xxs, ";padding-inline:", euiTheme.size.s, ";transform:translateX(0) translateY(-50%);", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), " line-height:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').lineHeight, ";color:", euiTheme.colors.ghost, ";background-color:", euiToolTipBackgroundColor(euiTheme, colorMode), ";border:", euiTheme.border.width.thin, " solid ", euiToolTipBackgroundColor(euiTheme, colorMode), ";border-radius:", euiTheme.border.radius.small, ";&::before{content:'';position:absolute;inset-block-end:50%;inline-size:", arrowSize, ";block-size:", arrowSize, ";transform-origin:center;transform:translateY(50%) rotateZ(45deg);background-color:", euiToolTipBackgroundColor(euiTheme, colorMode), ";border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";};label:euiRangeTooltip__value;"),
    left: /*#__PURE__*/(0, _react.css)("margin-inline-end:", euiTheme.size.l, ";&::before{inset-inline-end:", arrowMinusSize, ";};label:left;"),
    right: /*#__PURE__*/(0, _react.css)("margin-inline-start:", euiTheme.size.l, ";&::before{inset-inline-start:", arrowMinusSize, ";};label:right;"),
    hasTicks: /*#__PURE__*/(0, _react.css)("inset-block-start:", (0, _global_styling.mathWithUnits)(range.thumbWidth, function (x) {
      return x / 2;
    }), ";;label:hasTicks;")
  };
};
exports.euiRangeTooltipValueStyles = euiRangeTooltipValueStyles;