"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormControlLayoutDelimited = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _text = require("../../text");
var _form_control_layout = require("./form_control_layout");
var _react2 = require("@emotion/react");
var _excluded = ["startControl", "endControl", "delimiter", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiFormControlLayoutDelimited = function EuiFormControlLayoutDelimited(_ref) {
  var startControl = _ref.startControl,
    endControl = _ref.endControl,
    delimiter = _ref.delimiter,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isInvalid = rest.isInvalid,
    isDisabled = rest.isDisabled,
    readOnly = rest.readOnly;
  var showInvalidState = isInvalid && !isDisabled && !readOnly;
  var classes = (0, _classnames.default)('euiFormControlLayoutDelimited', className, {
    'euiFormControlLayoutDelimited--isInvalid': showInvalidState
  });
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, _extends({
    className: classes,
    iconsPosition: "static"
  }, rest), addClassesToControl(startControl), (0, _react2.jsx)(EuiFormControlDelimiter, {
    delimiter: delimiter,
    isInvalid: showInvalidState
  }), addClassesToControl(endControl));
};
exports.EuiFormControlLayoutDelimited = EuiFormControlLayoutDelimited;
EuiFormControlLayoutDelimited.propTypes = {
  /**
       * Left side control
       */
  startControl: _propTypes.default.element.isRequired,
  /**
       * Right side control
       */
  endControl: _propTypes.default.element.isRequired,
  /**
       * The center content. Accepts a string to be wrapped in a subdued EuiText
       * or a single ReactElement
       */
  delimiter: _propTypes.default.node,
  className: _propTypes.default.string
};
var addClassesToControl = function addClassesToControl(control) {
  return /*#__PURE__*/(0, _react.cloneElement)(control, {
    className: (0, _classnames.default)(control.props.className, 'euiFormControlLayoutDelimited__input')
  });
};
var EuiFormControlDelimiter = function EuiFormControlDelimiter(_ref2) {
  var delimiter = _ref2.delimiter,
    isInvalid = _ref2.isInvalid;
  var defaultAriaLabel = (0, _i18n.useEuiI18n)('euiFormControlLayoutDelimited.delimiterLabel', 'to');
  return (0, _react2.jsx)(_text.EuiText, {
    className: "euiFormControlLayoutDelimited__delimiter",
    size: "s",
    color: isInvalid ? 'danger' : 'subdued'
  }, delimiter !== null && delimiter !== void 0 ? delimiter : (0, _react2.jsx)(_icon.EuiIcon, {
    type: "sortRight",
    "aria-label": defaultAriaLabel
  }));
};