"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCellPopoverActions = exports.EuiDataGridCellActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("../../i18n");
var _button_icon = require("../../button/button_icon");
var _button_empty = require("../../button/button_empty");
var _flex = require("../../flex");
var _popover = require("../../popover");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); } /*
                                                                                                                                                                                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                     */
var EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var onExpandClick = _ref.onExpandClick,
    column = _ref.column,
    rowIndex = _ref.rowIndex,
    colIndex = _ref.colIndex,
    cellHeightType = _ref.cellHeightType;
  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = (0, _react2.jsx)(_i18n.EuiI18n, {
    key: 'expand',
    token: "euiDataGridCellActions.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return (0, _react2.jsx)(_button_icon.EuiButtonIcon, {
      display: "fill",
      className: "euiDataGridRowCell__actionButtonIcon",
      "data-test-subj": "euiDataGridCellExpandButton",
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });
  var additionalButtons = (0, _react.useMemo)(function () {
    if (!column || !Array.isArray(column === null || column === void 0 ? void 0 : column.cellActions)) return [];
    var ButtonComponent = function ButtonComponent(props) {
      return (0, _react2.jsx)(_button_icon.EuiButtonIcon, _extends({}, props, {
        "aria-hidden": true,
        className: "euiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };
    var _getVisibleCellAction = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
      _getVisibleCellAction2 = _slicedToArray(_getVisibleCellAction, 1),
      visibleCellActions = _getVisibleCellAction2[0];
    return visibleCellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return (0, _react2.jsx)(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false
      });
    });
  }, [column, colIndex, rowIndex]);
  var classes = (0, _classnames.default)('euiDataGridRowCell__actions', {
    'euiDataGridRowCell__actions--overlay': cellHeightType !== 'default'
  });
  return (0, _react2.jsx)("div", {
    className: classes
  }, [].concat(_toConsumableArray(additionalButtons), [expandButton]));
};
exports.EuiDataGridCellActions = EuiDataGridCellActions;
var EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var rowIndex = _ref2.rowIndex,
    colIndex = _ref2.colIndex,
    column = _ref2.column;
  var _getVisibleCellAction3 = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
    _getVisibleCellAction4 = _slicedToArray(_getVisibleCellAction3, 2),
    primaryActions = _getVisibleCellAction4[0],
    secondaryActions = _getVisibleCellAction4[1];
  var renderActions = (0, _react.useCallback)(function (Action, idx) {
    var ActionButtonElement = Action;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      key: idx
    }, (0, _react2.jsx)("div", null, (0, _react2.jsx)(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return (0, _react2.jsx)(_button_empty.EuiButtonEmpty, _extends({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    })));
  }, [column, colIndex, rowIndex]);
  return (0, _react2.jsx)(_react.default.Fragment, null, primaryActions.length > 0 && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, primaryActions.map(renderActions))), secondaryActions.length > 0 && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    alignItems: "flexStart"
  }, secondaryActions.map(renderActions))));
};

// Util helper to separate primary actions (columns.visibleCellActions, defaults to 2)
// and secondary actions (all remaning actions)
exports.EuiDataGridCellPopoverActions = EuiDataGridCellPopoverActions;
var getVisibleCellActions = function getVisibleCellActions(cellActions) {
  var visibleCellActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  if (!cellActions) return [[], []];
  if (cellActions.length <= visibleCellActions) return [cellActions, []];
  var primaryCellActions = cellActions.slice(0, visibleCellActions);
  var remainingCellActions = cellActions.slice(visibleCellActions);
  return [primaryCellActions, remainingCellActions];
};