"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverflow = void 0;
var _react = require("react");
var _mutation_observer = require("../observer/mutation_observer");
var _resize_observer = require("../observer/resize_observer");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */
/**
 * Overflow logic - returns overflow-related state/logic/utils
 *
 * Detects whether the code block overflows and returns a tabIndex of 0 if so,
 * which allows keyboard users to use the up/down arrow keys to scroll through
 * the container.
 */
var useOverflow = function useOverflow(_ref) {
  var overflowHeight = _ref.overflowHeight;
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    wrapperRef = _useState2[0],
    setWrapperRef = _useState2[1];
  var _useState3 = (0, _react.useState)(-1),
    _useState4 = _slicedToArray(_useState3, 2),
    tabIndex = _useState4[0],
    setTabIndex = _useState4[1];
  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(wrapperRef),
    width = _useResizeObserver.width,
    height = _useResizeObserver.height;
  var doesOverflow = function doesOverflow() {
    if (!wrapperRef) return;
    var clientWidth = wrapperRef.clientWidth,
      clientHeight = wrapperRef.clientHeight,
      scrollWidth = wrapperRef.scrollWidth,
      scrollHeight = wrapperRef.scrollHeight;
    var doesOverflow = scrollHeight > clientHeight || scrollWidth > clientWidth;
    setTabIndex(doesOverflow ? 0 : -1);
  };
  (0, _mutation_observer.useMutationObserver)(wrapperRef, doesOverflow, {
    subtree: true,
    childList: true
  });
  (0, _react.useEffect)(doesOverflow, [width, height, wrapperRef]);
  var overflowHeightStyles = (0, _react.useMemo)(function () {
    if (overflowHeight) {
      var property = typeof overflowHeight === 'string' ? 'blockSize' : 'maxBlockSize';
      return _defineProperty({}, property, overflowHeight);
    }
    return {};
  }, [overflowHeight]);
  return {
    setWrapperRef: setWrapperRef,
    tabIndex: tabIndex,
    overflowHeightStyles: overflowHeightStyles
  };
};
exports.useOverflow = useOverflow;