"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiButton = exports.COLORS = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../../themes/amsterdam/global_styling/mixins/button");
var _button_display = require("./button_display/_button_display");
var _react2 = require("@emotion/react");
var _excluded = ["className", "buttonRef", "size", "color", "fill"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var COLORS = _button.BUTTON_COLORS;
exports.COLORS = COLORS;
var SIZES = ['s', 'm'];
exports.SIZES = SIZES;
/**
 * EuiButton is largely responsible for providing relevant props
 * and the logic for element-specific attributes
 */
var EuiButton = function EuiButton(_ref) {
  var className = _ref.className,
    buttonRef = _ref.buttonRef,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    fill = _ref.fill,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isDisabled = (0, _button_display.isButtonDisabled)({
    href: rest.href,
    isDisabled: rest.isDisabled || rest.disabled,
    isLoading: rest.isLoading
  });
  var buttonColorStyles = (0, _button.useEuiButtonColorCSS)({
    display: fill ? 'fill' : 'base'
  })[isDisabled ? 'disabled' : color];
  var buttonFocusStyle = (0, _button.useEuiButtonFocusCSS)();
  var classes = (0, _classnames.default)('euiButton', className);
  var cssStyles = [buttonColorStyles, buttonFocusStyle];
  return (0, _react2.jsx)(_button_display.EuiButtonDisplay, _extends({
    className: classes,
    css: cssStyles,
    ref: buttonRef,
    size: size
  }, rest));
};
exports.EuiButton = EuiButton;
EuiButton.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     */
  color: _propTypes.default.any,
  /**
     * Use size `s` in confined spaces
     */
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * `disabled` is also allowed
     */
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any
};