"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zodToJsonSchema = void 0;
const parseDef_1 = require("./parseDef");
const Refs_1 = require("./Refs");
const zodToJsonSchema = (schema, options) => {
    var _a;
    const refs = (0, Refs_1.getRefs)(options);
    const definitions = typeof options === "object" && options.definitions
        ? Object.entries(options.definitions).reduce((acc, [name, schema]) => {
            var _a;
            return (Object.assign(Object.assign({}, acc), { [name]: (_a = (0, parseDef_1.parseDef)(schema._def, Object.assign(Object.assign({}, refs), { currentPath: [...refs.basePath, refs.definitionPath, name] }), true)) !== null && _a !== void 0 ? _a : {} }));
        }, {})
        : undefined;
    const name = typeof options === "string" ? options : options === null || options === void 0 ? void 0 : options.name;
    const main = (_a = (0, parseDef_1.parseDef)(schema._def, name === undefined
        ? refs
        : Object.assign(Object.assign({}, refs), { currentPath: [...refs.basePath, refs.definitionPath, name] }), false)) !== null && _a !== void 0 ? _a : {};
    const combined = name === undefined
        ? definitions
            ? Object.assign(Object.assign({}, main), { [refs.definitionPath]: definitions }) : main
        : {
            $ref: [
                ...(refs.$refStrategy === "relative" ? [] : refs.basePath),
                refs.definitionPath,
                name,
            ].join("/"),
            [refs.definitionPath]: Object.assign(Object.assign({}, definitions), { [name]: main }),
        };
    if (refs.target === "jsonSchema7") {
        combined.$schema = "http://json-schema.org/draft-07/schema#";
    }
    else if (refs.target === "jsonSchema2019-09") {
        combined.$schema = "https://json-schema.org/draft/2019-09/schema#";
    }
    return combined;
};
exports.zodToJsonSchema = zodToJsonSchema;
