"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var React = tslib_1.__importStar(require("react"));
var react_1 = require("react");
var useSetState_1 = tslib_1.__importDefault(require("../useSetState"));
var parseTimeRanges_1 = tslib_1.__importDefault(require("./parseTimeRanges"));
var createHTMLMediaHook = function (tag) { return function (elOrProps) {
    var element;
    var props;
    if (React.isValidElement(elOrProps)) {
        element = elOrProps;
        props = element.props;
    }
    else {
        props = elOrProps;
    }
    var _a = useSetState_1.default({
        buffered: [],
        time: 0,
        duration: 0,
        paused: true,
        muted: false,
        volume: 1,
    }), state = _a[0], setState = _a[1];
    var ref = react_1.useRef(null);
    var wrapEvent = function (userEvent, proxyEvent) {
        return function (event) {
            try {
                proxyEvent && proxyEvent(event);
            }
            finally {
                userEvent && userEvent(event);
            }
        };
    };
    var onPlay = function () { return setState({ paused: false }); };
    var onPause = function () { return setState({ paused: true }); };
    var onVolumeChange = function () {
        var el = ref.current;
        if (!el) {
            return;
        }
        setState({
            muted: el.muted,
            volume: el.volume,
        });
    };
    var onDurationChange = function () {
        var el = ref.current;
        if (!el) {
            return;
        }
        var duration = el.duration, buffered = el.buffered;
        setState({
            duration: duration,
            buffered: parseTimeRanges_1.default(buffered),
        });
    };
    var onTimeUpdate = function () {
        var el = ref.current;
        if (!el) {
            return;
        }
        setState({ time: el.currentTime });
    };
    var onProgress = function () {
        var el = ref.current;
        if (!el) {
            return;
        }
        setState({ buffered: parseTimeRanges_1.default(el.buffered) });
    };
    if (element) {
        element = React.cloneElement(element, tslib_1.__assign(tslib_1.__assign({ controls: false }, props), { ref: ref, onPlay: wrapEvent(props.onPlay, onPlay), onPause: wrapEvent(props.onPause, onPause), onVolumeChange: wrapEvent(props.onVolumeChange, onVolumeChange), onDurationChange: wrapEvent(props.onDurationChange, onDurationChange), onTimeUpdate: wrapEvent(props.onTimeUpdate, onTimeUpdate), onProgress: wrapEvent(props.onProgress, onProgress) }));
    }
    else {
        element = React.createElement(tag, tslib_1.__assign(tslib_1.__assign({ controls: false }, props), { ref: ref, onPlay: wrapEvent(props.onPlay, onPlay), onPause: wrapEvent(props.onPause, onPause), onVolumeChange: wrapEvent(props.onVolumeChange, onVolumeChange), onDurationChange: wrapEvent(props.onDurationChange, onDurationChange), onTimeUpdate: wrapEvent(props.onTimeUpdate, onTimeUpdate), onProgress: wrapEvent(props.onProgress, onProgress) })); // TODO: fix this typing.
    }
    // Some browsers return `Promise` on `.play()` and may throw errors
    // if one tries to execute another `.play()` or `.pause()` while that
    // promise is resolving. So we prevent that with this lock.
    // See: https://bugs.chromium.org/p/chromium/issues/detail?id=593273
    var lockPlay = false;
    var controls = {
        play: function () {
            var el = ref.current;
            if (!el) {
                return undefined;
            }
            if (!lockPlay) {
                var promise = el.play();
                var isPromise = typeof promise === 'object';
                if (isPromise) {
                    lockPlay = true;
                    var resetLock = function () {
                        lockPlay = false;
                    };
                    promise.then(resetLock, resetLock);
                }
                return promise;
            }
            return undefined;
        },
        pause: function () {
            var el = ref.current;
            if (el && !lockPlay) {
                return el.pause();
            }
        },
        seek: function (time) {
            var el = ref.current;
            if (!el || state.duration === undefined) {
                return;
            }
            time = Math.min(state.duration, Math.max(0, time));
            el.currentTime = time;
        },
        volume: function (volume) {
            var el = ref.current;
            if (!el) {
                return;
            }
            volume = Math.min(1, Math.max(0, volume));
            el.volume = volume;
            setState({ volume: volume });
        },
        mute: function () {
            var el = ref.current;
            if (!el) {
                return;
            }
            el.muted = true;
        },
        unmute: function () {
            var el = ref.current;
            if (!el) {
                return;
            }
            el.muted = false;
        },
    };
    react_1.useEffect(function () {
        var el = ref.current;
        if (!el) {
            if (process.env.NODE_ENV !== 'production') {
                if (tag === 'audio') {
                    console.error('useAudio() ref to <audio> element is empty at mount. ' +
                        'It seem you have not rendered the audio element, which it ' +
                        'returns as the first argument const [audio] = useAudio(...).');
                }
                else if (tag === 'video') {
                    console.error('useVideo() ref to <video> element is empty at mount. ' +
                        'It seem you have not rendered the video element, which it ' +
                        'returns as the first argument const [video] = useVideo(...).');
                }
            }
            return;
        }
        setState({
            volume: el.volume,
            muted: el.muted,
            paused: el.paused,
        });
        // Start media, if autoPlay requested.
        if (props.autoPlay && el.paused) {
            controls.play();
        }
    }, [props.src]);
    return [element, state, controls, ref];
}; };
exports.default = createHTMLMediaHook;
