import { ToolMessage, AIMessage, } from "../../schema/index.js";
export function formatToOpenAIToolMessages(steps) {
    return steps.flatMap(({ action, observation }) => {
        if ("messageLog" in action && action.messageLog !== undefined) {
            const log = action.messageLog;
            return log.concat(new ToolMessage({
                content: observation,
                tool_call_id: action.toolCallId,
            }));
        }
        else {
            return [new AIMessage(action.log)];
        }
    });
}
