/* eslint-disable import/extensions */
import { convertTokenBytePairEncodingFromTuples } from './convertTokenBytePairEncodingFromTuples.js';
import cl100k from './encodings/cl100k_base.js';
import p50k from './encodings/p50k_base.js';
import r50k from './encodings/r50k_base.js';
export const resolveEncoding = (encoding) => {
    switch (encoding) {
        case 'r50k_base':
            return convertTokenBytePairEncodingFromTuples(r50k);
        case 'p50k_base':
        case 'p50k_edit':
            return convertTokenBytePairEncodingFromTuples(p50k);
        case 'cl100k_base':
            return convertTokenBytePairEncodingFromTuples(cl100k);
        default: {
            throw new Error(`Unknown encoding name: ${encoding}`);
        }
    }
};
//# sourceMappingURL=resolveEncoding.js.map