"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSpecialTokenRegex = exports.getMaxValueFromMap = void 0;
const escapeRegExp_js_1 = require("./escapeRegExp.js");
function getMaxValueFromMap(map) {
    let max = 0;
    map.forEach((val) => {
        max = Math.max(max, val);
    });
    return max;
}
exports.getMaxValueFromMap = getMaxValueFromMap;
function getSpecialTokenRegex(tokens) {
    const escapedTokens = [...tokens].map(escapeRegExp_js_1.escapeRegExp);
    const inner = escapedTokens.join('|');
    return new RegExp(`(${inner})`);
}
exports.getSpecialTokenRegex = getSpecialTokenRegex;
//# sourceMappingURL=util.js.map