import { __awaiter, __generator, __values } from "tslib";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { promises as fs } from 'fs';
import { diag } from '@opentelemetry/api';
export function getMachineId() {
    return __awaiter(this, void 0, void 0, function () {
        var paths, paths_1, paths_1_1, path, result, e_1, e_2_1;
        var e_2, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    paths = ['/etc/machine-id', '/var/lib/dbus/machine-id'];
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 8, 9, 10]);
                    paths_1 = __values(paths), paths_1_1 = paths_1.next();
                    _b.label = 2;
                case 2:
                    if (!!paths_1_1.done) return [3 /*break*/, 7];
                    path = paths_1_1.value;
                    _b.label = 3;
                case 3:
                    _b.trys.push([3, 5, , 6]);
                    return [4 /*yield*/, fs.readFile(path, { encoding: 'utf8' })];
                case 4:
                    result = _b.sent();
                    return [2 /*return*/, result.trim()];
                case 5:
                    e_1 = _b.sent();
                    diag.debug("error reading machine id: " + e_1);
                    return [3 /*break*/, 6];
                case 6:
                    paths_1_1 = paths_1.next();
                    return [3 /*break*/, 2];
                case 7: return [3 /*break*/, 10];
                case 8:
                    e_2_1 = _b.sent();
                    e_2 = { error: e_2_1 };
                    return [3 /*break*/, 10];
                case 9:
                    try {
                        if (paths_1_1 && !paths_1_1.done && (_a = paths_1.return)) _a.call(paths_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                    return [7 /*endfinally*/];
                case 10: return [2 /*return*/, ''];
            }
        });
    });
}
//# sourceMappingURL=getMachineId-linux.js.map