/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { __awaiter, __generator } from "tslib";
import { promises as fs } from 'fs';
import { execAsync } from './execAsync';
import { diag } from '@opentelemetry/api';
export function getMachineId() {
    return __awaiter(this, void 0, void 0, function () {
        var result, e_1, result, e_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, fs.readFile('/etc/hostid', { encoding: 'utf8' })];
                case 1:
                    result = _a.sent();
                    return [2 /*return*/, result.trim()];
                case 2:
                    e_1 = _a.sent();
                    diag.debug("error reading machine id: " + e_1);
                    return [3 /*break*/, 3];
                case 3:
                    _a.trys.push([3, 5, , 6]);
                    return [4 /*yield*/, execAsync('kenv -q smbios.system.uuid')];
                case 4:
                    result = _a.sent();
                    return [2 /*return*/, result.stdout.trim()];
                case 5:
                    e_2 = _a.sent();
                    diag.debug("error reading machine id: " + e_2);
                    return [3 /*break*/, 6];
                case 6: return [2 /*return*/, ''];
            }
        });
    });
}
//# sourceMappingURL=getMachineId-bsd.js.map