"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeApp = void 0;
require("./app.scss");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageAnalyticsNoData = require("@kbn/shared-ux-page-analytics-no-data");
var _components = require("./components");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NoDataComponent = ({
  core,
  dataViews,
  dataViewEditor,
  onDataViewCreated,
  noDataPage
}) => {
  const analyticsServices = {
    coreStart: core,
    dataViews,
    dataViewEditor,
    noDataPage
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageAnalyticsNoData.AnalyticsNoDataPageKibanaProvider, analyticsServices, /*#__PURE__*/_react.default.createElement(_sharedUxPageAnalyticsNoData.AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated
  }));
};
const VisualizeApp = ({
  onAppLeave
}) => {
  const {
    services: {
      data: {
        query,
        dataViews
      },
      core,
      kbnUrlStateStorage,
      dataViewEditor,
      noDataPage
    }
  } = (0, _public2.useKibana)();
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const onDataViewCreated = (0, _react.useCallback)(dataView => {
    if (dataView) {
      setShowNoDataPage(false);
    }
  }, []);
  (0, _react.useEffect)(() => {
    // syncs `_g` portion of url with query services
    const {
      stop
    } = (0, _public.syncGlobalQueryStateWithUrl)(query, kbnUrlStateStorage);
    return () => stop();

    // this effect should re-run when pathname is changed to preserve querystring part,
    // so the global state is always preserved
  }, [query, kbnUrlStateStorage, pathname]);
  (0, _react.useEffect)(() => {
    const checkESOrDataViewExist = async () => {
      // check if there is any data view or data source
      const hasUserDataView = await dataViews.hasData.hasUserDataView().catch(() => false);
      if (hasUserDataView) {
        // Adding this check as TSVB asks for the default dataview on initialization
        const defaultDataView = await dataViews.defaultDataViewExists();
        if (!defaultDataView) {
          setShowNoDataPage(true);
        }
        setIsLoading(false);
        return;
      }
      setShowNoDataPage(true);
      setIsLoading(false);
    };

    // call the function
    checkESOrDataViewExist();
  }, [dataViews]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "visAppLoadingWrapper"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }));
  }

  // Visualize app should return the noData component if there is no data view or data source
  if (showNoDataPage) {
    return /*#__PURE__*/_react.default.createElement(NoDataComponent, {
      core: core,
      dataViewEditor: dataViewEditor,
      dataViews: dataViews,
      onDataViewCreated: onDataViewCreated,
      noDataPage: noDataPage
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.VisualizeConstants.EDIT_BY_VALUE_PATH}`
  }, /*#__PURE__*/_react.default.createElement(_components.VisualizeByValueEditor, {
    onAppLeave: onAppLeave
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: [_constants.VisualizeConstants.CREATE_PATH, `${_constants.VisualizeConstants.EDIT_PATH}/:id`]
  }, /*#__PURE__*/_react.default.createElement(_components.VisualizeEditor, {
    onAppLeave: onAppLeave
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [_constants.VisualizeConstants.LANDING_PAGE_PATH, _constants.VisualizeConstants.WIZARD_STEP_1_PAGE_PATH, _constants.VisualizeConstants.LANDING_PAGE_PATH_WITH_TAB]
  }, /*#__PURE__*/_react.default.createElement(_components.VisualizeListing, null)), /*#__PURE__*/_react.default.createElement(_components.VisualizeNoMatch, null));
};
exports.VisualizeApp = VisualizeApp;