"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YExtents = YExtents;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _types = require("../../../../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const rangeError = _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.minErrorMessage', {
  defaultMessage: 'Min should be less than Max.'
});
const minError = _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.minNeededScaleText', {
  defaultMessage: 'Min must exceed 0 when a log scale is selected.'
});
function areExtentsValid(min = null, max = null) {
  if (min === null || max === null) {
    return true;
  }
  return max > min;
}
function isNullOrUndefined(value) {
  return value === null || value === undefined;
}
function YExtents({
  scale,
  setScale,
  setMultipleValidity
}) {
  const {
    min,
    max,
    type
  } = scale;
  const errors = [];
  if (!areExtentsValid(min, max)) {
    errors.push(rangeError);
  }
  if (type === _types.ScaleType.Log && (isNullOrUndefined(min) || min <= 0)) {
    errors.push(minError);
  }
  const isValid = !errors.length;
  const setExtents = (0, _react.useCallback)((paramName, value) => {
    setScale(paramName, value === '' ? null : value);
  }, [setScale]);
  (0, _react.useEffect)(() => {
    setMultipleValidity('yExtents', isValid);
    return () => setMultipleValidity('yExtents', true);
  }, [isValid, setMultipleValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: errors,
    isInvalid: !!errors.length,
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    "data-test-subj": "yAxisYExtentsMin",
    isInvalid: !!errors.length,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.minLabel', {
      defaultMessage: 'Min'
    }),
    step: 0.1,
    paramName: "min",
    value: isNullOrUndefined(min) ? '' : min,
    setValue: setExtents
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    "data-test-subj": "yAxisYExtentsMax",
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.maxLabel', {
      defaultMessage: 'Max'
    }),
    step: 0.1,
    paramName: "max",
    value: isNullOrUndefined(max) ? '' : max,
    setValue: setExtents
  })))));
}