"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueAxesPanel = ValueAxesPanel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _value_axis_options = require("./value_axis_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ValueAxesPanel(props) {
  const {
    addValueAxis,
    removeValueAxis,
    seriesParams,
    valueAxes
  } = props;
  const getSeries = (0, _react.useCallback)(axis => {
    const isFirst = valueAxes[0].id === axis.id;
    const series = seriesParams.filter(serie => serie.valueAxis === axis.id || isFirst && !serie.valueAxis);
    return series.map(serie => serie.data.label).join(', ');
  }, [seriesParams, valueAxes]);
  const removeButtonTooltip = (0, _react.useMemo)(() => _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.removeButtonTooltip', {
    defaultMessage: 'Remove Y-axis'
  }), []);
  const renderRemoveButton = (0, _react.useCallback)(axis => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: removeButtonTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "cross",
    onClick: () => removeValueAxis(axis),
    "aria-label": removeButtonTooltip,
    "data-test-subj": "removeValueAxisBtn"
  })), [removeValueAxis, removeButtonTooltip]);
  const addButtonTooltip = (0, _react.useMemo)(() => _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.addButtonTooltip', {
    defaultMessage: 'Add Y-axis'
  }), []);
  const getButtonContent = (0, _react.useCallback)(axis => {
    const description = getSeries(axis);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, axis.name, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: description
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description)));
  }, [getSeries]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.valueAxes.yAxisTitle",
    defaultMessage: "Y-axes"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: addButtonTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircleFilled",
    onClick: addValueAxis,
    "aria-label": addButtonTooltip,
    "data-test-subj": "visualizeAddYAxisButton"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), valueAxes.map((axis, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `yAxisAccordion${axis.id}`,
    key: axis.id,
    "data-test-subj": `toggleYAxisOptions-${axis.id}`,
    className: "visEditorSidebar__section visEditorSidebar__collapsible",
    initialIsOpen: false,
    buttonContent: getButtonContent(axis),
    buttonClassName: "eui-textTruncate",
    buttonContentClassName: "visEditorSidebar__aggGroupAccordionButtonContent eui-textTruncate",
    "aria-label": _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.toggleOptionsAriaLabel', {
      defaultMessage: 'Toggle {axisName} options',
      values: {
        axisName: axis.name
      }
    }),
    extraAction: valueAxes.length === 1 ? undefined : renderRemoveButton(axis)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_value_axis_options.ValueAxisOptions, {
    axis: axis,
    index: index,
    valueAxis: valueAxes[index],
    onValueAxisPositionChanged: props.onValueAxisPositionChanged,
    setParamByIndex: props.setParamByIndex,
    setMultipleValidity: props.setMultipleValidity
  })))));
}