"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesPanel = SeriesPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _chart_options = require("./chart_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SeriesPanel({
  seriesParams,
  ...chartProps
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.series.metricsTitle",
    defaultMessage: "Metrics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), seriesParams.map((chart, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `visEditorSeriesAccordion${chart.data.id}`,
    key: index,
    className: "visEditorSidebar__section visEditorSidebar__collapsible",
    initialIsOpen: index === 0,
    buttonContent: chart.data.label,
    buttonContentClassName: "visEditorSidebar__aggGroupAccordionButtonContent eui-textTruncate",
    "aria-label": _i18n.i18n.translate('visTypeXy.controls.pointSeries.seriesAccordionAriaLabel', {
      defaultMessage: 'Toggle {agg} options',
      values: {
        agg: chart.data.label
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_chart_options.ChartOptions, (0, _extends2.default)({
    index: index,
    chart: chart
  }, chartProps))))));
}