"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PointOptions = PointOptions;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function PointOptions({
  chart,
  setChart
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.showDotsLabel', {
      defaultMessage: 'Show dots'
    }),
    paramName: "showCircles",
    value: chart.showCircles,
    setValue: setChart
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.circlesRadius', {
      defaultMessage: 'Dots size'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    "data-test-subj": "circlesRadius",
    value: chart.circlesRadius,
    min: 1,
    max: 10,
    step: 1,
    fullWidth: true,
    disabled: !chart.showCircles,
    showInput: true,
    compressed: true,
    onChange: e => {
      setChart('circlesRadius', Number(e.currentTarget.value));
    }
  })));
}