"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInterpolationModes = exports.getFittingFunctions = exports.getConfigCollections = exports.getChartTypes = exports.getChartModes = exports.getAxisModes = void 0;
Object.defineProperty(exports, "getPositions", {
  enumerable: true,
  get: function () {
    return _positions.getPositions;
  }
});
exports.getRotateOptions = void 0;
Object.defineProperty(exports, "getScaleTypes", {
  enumerable: true,
  get: function () {
    return _scale_types.getScaleTypes;
  }
});
exports.getThresholdLineStyles = void 0;
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _public = require("@kbn/charts-plugin/public");
var _types = require("../types");
var _common = require("../../common");
var _scale_types = require("./scale_types");
var _positions = require("./positions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getChartTypes = () => [{
  text: _i18n.i18n.translate('visTypeXy.chartTypes.lineText', {
    defaultMessage: 'Line'
  }),
  value: _common.ChartType.Line
}, {
  text: _i18n.i18n.translate('visTypeXy.chartTypes.areaText', {
    defaultMessage: 'Area'
  }),
  value: _common.ChartType.Area
}, {
  text: _i18n.i18n.translate('visTypeXy.chartTypes.barText', {
    defaultMessage: 'Bar'
  }),
  value: _common.ChartType.Histogram
}];
exports.getChartTypes = getChartTypes;
const getChartModes = () => [{
  text: _i18n.i18n.translate('visTypeXy.chartModes.normalText', {
    defaultMessage: 'Normal'
  }),
  value: _types.ChartMode.Normal
}, {
  text: _i18n.i18n.translate('visTypeXy.chartModes.stackedText', {
    defaultMessage: 'Stacked'
  }),
  value: _types.ChartMode.Stacked
}];
exports.getChartModes = getChartModes;
const getInterpolationModes = () => [{
  text: _i18n.i18n.translate('visTypeXy.interpolationModes.straightText', {
    defaultMessage: 'Straight'
  }),
  value: _types.InterpolationMode.Linear
}, {
  text: _i18n.i18n.translate('visTypeXy.interpolationModes.smoothedText', {
    defaultMessage: 'Smoothed'
  }),
  value: _types.InterpolationMode.Cardinal
}, {
  text: _i18n.i18n.translate('visTypeXy.interpolationModes.steppedText', {
    defaultMessage: 'Stepped'
  }),
  value: _types.InterpolationMode.StepAfter
}];
exports.getInterpolationModes = getInterpolationModes;
const getAxisModes = () => [{
  text: _i18n.i18n.translate('visTypeXy.axisModes.normalText', {
    defaultMessage: 'Normal'
  }),
  value: _types.AxisMode.Normal
}, {
  text: _i18n.i18n.translate('visTypeXy.axisModes.percentageText', {
    defaultMessage: 'Percentage'
  }),
  value: _types.AxisMode.Percentage
}, {
  text: _i18n.i18n.translate('visTypeXy.axisModes.wiggleText', {
    defaultMessage: 'Wiggle'
  }),
  value: _types.AxisMode.Wiggle
}, {
  text: _i18n.i18n.translate('visTypeXy.axisModes.silhouetteText', {
    defaultMessage: 'Silhouette'
  }),
  value: _types.AxisMode.Silhouette
}];
exports.getAxisModes = getAxisModes;
const getThresholdLineStyles = () => [{
  value: _types.ThresholdLineStyle.Full,
  text: _i18n.i18n.translate('visTypeXy.thresholdLine.style.fullText', {
    defaultMessage: 'Full'
  })
}, {
  value: _types.ThresholdLineStyle.Dashed,
  text: _i18n.i18n.translate('visTypeXy.thresholdLine.style.dashedText', {
    defaultMessage: 'Dashed'
  })
}, {
  value: _types.ThresholdLineStyle.DotDashed,
  text: _i18n.i18n.translate('visTypeXy.thresholdLine.style.dotdashedText', {
    defaultMessage: 'Dot-dashed'
  })
}];
exports.getThresholdLineStyles = getThresholdLineStyles;
const getRotateOptions = () => [{
  text: _i18n.i18n.translate('visTypeXy.categoryAxis.rotate.horizontalText', {
    defaultMessage: 'Horizontal'
  }),
  value: _public.LabelRotation.Horizontal
}, {
  text: _i18n.i18n.translate('visTypeXy.categoryAxis.rotate.verticalText', {
    defaultMessage: 'Vertical'
  }),
  value: _public.LabelRotation.Vertical
}, {
  text: _i18n.i18n.translate('visTypeXy.categoryAxis.rotate.angledText', {
    defaultMessage: 'Angled'
  }),
  value: _public.LabelRotation.Angled
}];
exports.getRotateOptions = getRotateOptions;
const getFittingFunctions = () => [{
  value: _charts.Fit.None,
  text: _i18n.i18n.translate('visTypeXy.fittingFunctionsTitle.none', {
    defaultMessage: 'Hide (Do not fill gaps)'
  })
}, {
  value: _charts.Fit.Zero,
  text: _i18n.i18n.translate('visTypeXy.fittingFunctionsTitle.zero', {
    defaultMessage: 'Zero (Fill gaps with zeros)'
  })
}, {
  value: _charts.Fit.Linear,
  text: _i18n.i18n.translate('visTypeXy.fittingFunctionsTitle.linear', {
    defaultMessage: 'Linear (Fill gaps with a line)'
  })
}, {
  value: _charts.Fit.Carry,
  text: _i18n.i18n.translate('visTypeXy.fittingFunctionsTitle.carry', {
    defaultMessage: 'Last (Fill gaps with the last value)'
  })
}, {
  value: _charts.Fit.Lookahead,
  text: _i18n.i18n.translate('visTypeXy.fittingFunctionsTitle.lookahead', {
    defaultMessage: 'Next (Fill gaps with the next value)'
  })
}];
exports.getFittingFunctions = getFittingFunctions;
const getConfigCollections = () => ({
  legendPositions: (0, _positions.getPositions)(),
  positions: (0, _positions.getPositions)(),
  chartTypes: getChartTypes(),
  axisModes: getAxisModes(),
  scaleTypes: (0, _scale_types.getScaleTypes)(),
  chartModes: getChartModes(),
  interpolationModes: getInterpolationModes(),
  thresholdLineStyles: getThresholdLineStyles(),
  fittingFunctions: getFittingFunctions()
});
exports.getConfigCollections = getConfigCollections;