"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.positionTooltip = positionTooltip;
var _lodash = _interopRequireDefault(require("lodash"));
var _jquery = _interopRequireDefault(require("jquery"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OFFSET = 10;
let $clone;

// translate css properties into their basic direction
const propDirs = {
  top: 'north',
  left: 'west'
};
function positionTooltip(opts, html) {
  if (!opts) return;
  const $chart = (0, _jquery.default)(opts.$chart);
  const $el = (0, _jquery.default)(opts.$el);
  const $window = (0, _jquery.default)(opts.$window || window);
  const $sizer = (0, _jquery.default)(opts.$sizer);
  const prev = $chart.data('previousPlacement') || {};
  const event = opts.event;
  if (!$chart.length || !$el.length) return;
  const size = getTtSize(html || $el.html(), $sizer);
  const pos = getBasePosition(size, event);
  const overflow = getOverflow(size, pos, [$chart, $window]);
  const placement = placeToAvoidOverflow(pos, prev, overflow);
  $chart.data('previousPlacement', placement);
  return placement;
}
function getTtSize(ttHtml, $sizer) {
  if ($sizer.html() !== ttHtml) {
    $sizer.html(ttHtml);
  }
  const size = {
    width: $sizer.outerWidth(),
    height: $sizer.outerHeight()
  };
  return size;
}
function getBasePosition(size, event) {
  return {
    east: event.clientX + OFFSET,
    west: event.clientX - size.width - OFFSET,
    south: event.clientY + OFFSET,
    north: event.clientY - size.height - OFFSET
  };
}
function getBounds($el) {
  // in testing, $window is not actually a window, so we need to add
  // the offsets to make it work right.
  // Sometimes $el is a $(window), which doesn't have getBoundingClientRect()
  // which breaks in jQuery 3
  const bounds = _jquery.default.isWindow($el[0]) ? {
    top: 0,
    left: 0
  } : $el.offset();
  bounds.top += $el.scrollTop();
  bounds.left += $el.scrollLeft();
  bounds.bottom = bounds.top + $el.outerHeight();
  bounds.right = bounds.left + $el.outerWidth();
  bounds.area = (bounds.bottom - bounds.top) * (bounds.right - bounds.left);
  return bounds;
}
function getOverflow(size, pos, containers) {
  const overflow = {};
  containers.map(getBounds).sort(function (a, b) {
    // ensure smallest containers are merged first
    return a.area - b.area;
  }).forEach(function (bounds) {
    // number of pixels that the tooltip would overflow it's far
    // side, if we placed it that way. (negative === no overflow)
    mergeOverflows(overflow, {
      north: bounds.top - pos.north,
      east: pos.east + size.width - bounds.right,
      south: pos.south + size.height - bounds.bottom,
      west: bounds.left - pos.west
    });
  });
  (window.overflows || (window.overflows = [])).push(overflow);
  return overflow;
}
function mergeOverflows(dest, src) {
  _lodash.default.mergeWith(dest, src, function (a, b) {
    if (a == null || b == null) return a || b;
    if (a < 0 && b < 0) return Math.min(a, b);
    return Math.max(a, b);
  });

  // When tooltip overflows both sides of smaller container,
  // remove overflow on one side if the outer container can contain tooltip.
  if (dest.east && dest.west && dest.east > 0 && dest.west > 0 && (src.east < 0 || src.west < 0)) {
    if (src.east < src.west) {
      dest.east = src.east;
    } else {
      dest.west = src.west;
    }
  }
}
function pickPlacement(prop, pos, overflow, prev, pref, fallback, placement) {
  const stash = '_' + prop;

  // list of directions in order of preference
  const dirs = _lodash.default.uniq([prev[stash], pref, fallback].filter(Boolean));
  let dir;
  let value;

  // find the first direction that doesn't overflow
  for (let i = 0; i < dirs.length; i++) {
    dir = dirs[i];
    if (overflow[dir] > 0) continue;
    value = pos[dir];
    break;
  }

  // if we don't find one that doesn't overflow, use
  // the first choice and offset based on overflow
  if (value == null) {
    dir = dirs[0];
    let offset = overflow[dir];
    if (propDirs[prop] === dir) {
      // when the property represents the same direction
      // as dir, we flip the overflow
      offset = offset * -1;
    }
    value = pos[dir] - offset;
  }
  placement[prop] = value;
  placement[stash] = dir;
}
function placeToAvoidOverflow(pos, prev, overflow) {
  const placement = {};
  pickPlacement('top', pos, overflow, prev, 'south', 'north', placement);
  pickPlacement('left', pos, overflow, prev, 'east', 'west', placement);
  return placement;
}

// expose units/helpers for testing
positionTooltip.getTtSize = getTtSize;
positionTooltip.getBasePosition = getBasePosition;
positionTooltip.getOverflow = getOverflow;
positionTooltip.getBounds = getBounds;
positionTooltip.placeToAvoidOverflow = placeToAvoidOverflow;
positionTooltip.removeClone = function () {
  $clone && $clone.remove();
  $clone = null;
};