"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisLegendItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/charts-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VisLegendItemComponent = ({
  item,
  selected,
  canFilter,
  anchorPosition,
  onFilter,
  onSelect,
  onHighlight,
  onUnhighlight,
  setColor,
  getColor
}) => {
  const [idToSelectedMap, setIdToSelectedMap] = (0, _react.useState)({});
  /**
   * Keydown listener for a legend entry.
   * This will close the details panel of this legend entry when pressing Escape.
   */
  const onLegendEntryKeydown = event => {
    if (event.key === _eui.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      onSelect(null)();
    }
  };
  const filterOptions = [{
    id: 'filterIn',
    label: _i18n.i18n.translate('visTypeVislib.vislib.legend.filterForValueButtonAriaLabel', {
      defaultMessage: 'Filter for {legendDataLabel}',
      values: {
        legendDataLabel: item.label
      }
    }),
    iconType: 'plusInCircle',
    'data-test-subj': `legend-${item.label}-filterIn`
  }, {
    id: 'filterOut',
    label: _i18n.i18n.translate('visTypeVislib.vislib.legend.filterOutValueButtonAriaLabel', {
      defaultMessage: 'Filter out {legendDataLabel}',
      values: {
        legendDataLabel: item.label
      }
    }),
    iconType: 'minusInCircle',
    'data-test-subj': `legend-${item.label}-filterOut`
  }];
  const handleFilterChange = id => {
    setIdToSelectedMap({
      filterIn: id === 'filterIn',
      filterOut: id === 'filterOut'
    });
    onFilter(item, id !== 'filterIn');
  };
  const renderFilterBar = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "multi",
    isIconOnly: true,
    isFullWidth: true,
    legend: _i18n.i18n.translate('visTypeVislib.vislib.legend.filterOptionsLegend', {
      defaultMessage: '{legendDataLabel}, filter options',
      values: {
        legendDataLabel: item.label
      }
    }),
    options: filterOptions,
    onChange: handleFilterChange,
    "data-test-subj": `legend-${item.label}-filters`,
    idToSelectedMap: idToSelectedMap
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    flush: "left",
    className: "visLegend__button",
    onKeyDown: onLegendEntryKeydown,
    onMouseEnter: onHighlight,
    onFocus: onHighlight,
    onClick: onSelect(item.label),
    onMouseLeave: onUnhighlight,
    onBlur: onUnhighlight,
    "data-label": item.label,
    title: item.label,
    "aria-label": _i18n.i18n.translate('visTypeVislib.vislib.legend.toggleOptionsButtonAriaLabel', {
      defaultMessage: '{legendDataLabel}, toggle options',
      values: {
        legendDataLabel: item.label
      }
    }),
    "data-test-subj": `legend-${item.label}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "dot",
    color: getColor(item.label),
    "data-test-subj": `legendSelectedColor-${getColor(item.label)}`
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "visLegend__valueTitle"
  }, item.label));
  const renderDetails = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    button: button,
    isOpen: selected,
    anchorPosition: anchorPosition,
    closePopover: onSelect(null),
    panelPaddingSize: "s"
  }, canFilter && renderFilterBar(), /*#__PURE__*/_react.default.createElement(_public.ColorPicker, {
    label: item.label,
    color: getColor(item.label),
    onChange: (c, e) => setColor(item.label, c, e)
  }));
  return /*#__PURE__*/_react.default.createElement("li", {
    key: item.label,
    className: "visLegend__value"
  }, renderDetails());
};
const VisLegendItem = /*#__PURE__*/(0, _react.memo)(VisLegendItemComponent);
exports.VisLegendItem = VisLegendItem;