"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.truncateLabel = void 0;
var _jquery = _interopRequireDefault(require("jquery"));
var _d = _interopRequireDefault(require("d3"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/***
 *
 * @param text (d3 node containing text)
 * @param size (number of characters to leave)
 * @returns {text} the updated text
 */
const truncateLabel = function (text, size) {
  const node = _d.default.select(text).node();
  const str = (0, _jquery.default)(node).text();
  if (size === 0) return str;
  if (size >= str.length) return str;
  return str.substr(0, size) + '…';
};
exports.truncateLabel = truncateLabel;