"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisTypeVislibPlugin = void 0;
var _common = require("@kbn/vis-type-heatmap-plugin/common");
var _common2 = require("@kbn/vis-type-gauge-plugin/common");
var _services = require("./services");
var _heatmap = require("./heatmap");
var _vis_type_vislib_vis_fn = require("./vis_type_vislib_vis_fn");
var _vis_renderer = require("./vis_renderer");
var _gauge = require("./gauge");
var _goal = require("./goal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

/** @internal */
class VisTypeVislibPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    visualizations,
    charts
  }) {
    expressions.registerRenderer((0, _vis_renderer.getVislibVisRenderer)(core, charts));
    expressions.registerFunction((0, _vis_type_vislib_vis_fn.createVisTypeVislibVisFn)());
    const {
      readOnly
    } = this.initializerContext.config.get();
    if (core.uiSettings.get(_common.LEGACY_HEATMAP_CHARTS_LIBRARY)) {
      // register vislib heatmap chart
      visualizations.createBaseVisualization({
        ..._heatmap.heatmapVisTypeDefinition,
        disableCreate: Boolean(readOnly),
        disableEdit: Boolean(readOnly)
      });
    }
    if (core.uiSettings.get(_common2.LEGACY_GAUGE_CHARTS_LIBRARY)) {
      // register vislib gauge and goal charts
      visualizations.createBaseVisualization({
        ..._gauge.gaugeVisTypeDefinition,
        disableCreate: Boolean(readOnly),
        disableEdit: Boolean(readOnly)
      });
      visualizations.createBaseVisualization({
        ..._goal.goalVisTypeDefinition,
        disableCreate: Boolean(readOnly),
        disableEdit: Boolean(readOnly)
      });
    }
  }
  start(core, {
    data,
    usageCollection,
    fieldFormats
  }) {
    (0, _services.setFormatService)(fieldFormats);
    (0, _services.setDataActions)(data.actions);
    (0, _services.setTheme)(core.theme);
    if (usageCollection) {
      (0, _services.setUsageCollectionStart)(usageCollection);
    }
  }
}
exports.VisTypeVislibPlugin = VisTypeVislibPlugin;