"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _hjson = require("hjson");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _default_spec = require("./default_spec");
var _extract_index_pattern = require("./lib/extract_index_pattern");
var _vega_inspector = require("./vega_inspector");
var _to_ast = require("./to_ast");
var _vega_info_message = require("./components/vega_info_message");
var _vega_vis_editor_lazy = require("./components/vega_vis_editor_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createVegaTypeDefinition = () => {
  return {
    name: 'vega',
    title: 'Vega',
    getInfoMessage: _vega_info_message.getInfoMessage,
    description: _i18n.i18n.translate('visTypeVega.type.vegaDescription', {
      defaultMessage: 'Use Vega to create new types of visualizations.',
      description: 'Vega and Vega-Lite are product names and should not be translated'
    }),
    note: _i18n.i18n.translate('visTypeVega.type.vegaNote', {
      defaultMessage: 'Requires knowledge of Vega syntax.'
    }),
    icon: 'visVega',
    group: _public2.VisGroups.PROMOTED,
    titleInWizard: _i18n.i18n.translate('visTypeVega.type.vegaTitleInWizard', {
      defaultMessage: 'Custom visualization'
    }),
    visConfig: {
      defaults: {
        spec: (0, _default_spec.getDefaultSpec)()
      }
    },
    editorConfig: {
      optionsTemplate: _vega_vis_editor_lazy.VegaVisEditorComponent,
      enableAutoApply: true,
      defaultSize: _public.DefaultEditorSize.MEDIUM
    },
    toExpressionAst: _to_ast.toExpressionAst,
    options: {
      showIndexSelection: false,
      showFilterBar: true
    },
    getSupportedTriggers: () => {
      return [_public2.VIS_EVENT_TO_TRIGGER.applyFilter];
    },
    getUsedIndexPattern: async visParams => {
      try {
        const spec = (0, _hjson.parse)(visParams.spec, {
          legacyRoot: false,
          keepWsc: true
        });
        return (0, _extract_index_pattern.extractIndexPatternsFromSpec)(spec);
      } catch (e) {
        // spec is invalid
      }
      return [];
    },
    inspectorAdapters: _vega_inspector.createInspectorAdapters,
    /**
     * This is necessary for showing actions bar in top of vega editor
     */
    requiresSearch: true
  };
};
exports.createVegaTypeDefinition = createVegaTypeDefinition;