"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpecViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const copyToClipboardLabel = _i18n.i18n.translate('visTypeVega.inspector.specViewer.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});
const SpecViewer = ({
  vegaAdapter,
  ...rest
}) => {
  const [spec, setSpec] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const subscription = vegaAdapter.getSpecSubscription().subscribe(data => {
      if (data) {
        setSpec(data);
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [vegaAdapter]);
  if (!spec) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    direction: "column",
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: spec
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    "data-test-subj": "vegaDataInspectorCopyClipboardButton"
  }, copyToClipboardLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    value: spec,
    options: {
      readOnly: true,
      lineNumbers: 'off',
      fontSize: 12,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })));
};
exports.SpecViewer = SpecViewer;