"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/expressions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const toExpressionAst = vis => {
  const timeseries = (0, _public.buildExpressionFunction)('tsvb', {
    params: JSON.stringify(vis.params),
    uiState: JSON.stringify(vis.uiState)
  });
  const ast = (0, _public.buildExpression)([timeseries]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;