"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidMetrics = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isMetricValid = (metricType, panelType, field, timeRangeMode) => {
  const metric = _.SUPPORTED_METRICS[metricType];
  if (!metric) {
    return false;
  }
  const isPanelTypeSupported = metric.supportedPanelTypes.includes(panelType);
  const isTimeRangeModeSupported = !timeRangeMode || metric.supportedTimeRangeModes.includes(timeRangeMode);
  return isPanelTypeSupported && isTimeRangeModeSupported && (!metric.isFieldRequired || field);
};
const isValidMetrics = (metrics, panelType, timeRangeMode) => {
  return metrics.every(metric => {
    const isMetricAggValid = metric.type !== 'filter_ratio' || isMetricValid(metric.metric_agg || 'count', panelType, metric.field, timeRangeMode);
    return metric.type === 'series_agg' || isMetricValid(metric.type, panelType, metric.field, timeRangeMode) && isMetricAggValid;
  });
};
exports.isValidMetrics = isValidMetrics;