"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStaticValueColumn = exports.convertToStaticValueParams = exports.convertToStaticValueColumn = exports.convertStaticValueToFormulaColumn = void 0;
var _uuid = require("uuid");
var _column = require("./column");
var _formula = require("./formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToStaticValueParams = ({
  value
}) => ({
  value
});
exports.convertToStaticValueParams = convertToStaticValueParams;
const convertToStaticValueColumn = ({
  series,
  metrics,
  dataView
}, {
  visibleSeriesCount = 0,
  reducedTimeRange
} = {}) => {
  // Lens support reference lines only when at least one layer data exists
  if (visibleSeriesCount === 1) {
    return null;
  }
  const currentMetric = metrics[metrics.length - 1];
  if (!currentMetric.value) {
    return null;
  }
  return {
    operationType: 'static_value',
    references: [],
    ...(0, _column.createColumn)(series, currentMetric, undefined, {
      reducedTimeRange
    }),
    params: {
      ...convertToStaticValueParams(currentMetric),
      ...(0, _column.getFormat)(series)
    }
  };
};
exports.convertToStaticValueColumn = convertToStaticValueColumn;
const createStaticValueColumn = staticValue => ({
  columnId: (0, _uuid.v4)(),
  operationType: 'static_value',
  references: [],
  dataType: 'number',
  isStaticValue: true,
  isBucketed: false,
  isSplit: false,
  params: {
    value: staticValue.toString()
  }
});
exports.createStaticValueColumn = createStaticValueColumn;
const convertStaticValueToFormulaColumn = ({
  series,
  metrics,
  dataView
}, {
  visibleSeriesCount = 0,
  reducedTimeRange
} = {}) => {
  // Lens support reference lines only when at least one layer data exists
  if (visibleSeriesCount === 1) {
    return null;
  }
  const currentMetric = metrics[metrics.length - 1];
  if (!currentMetric.value) {
    return null;
  }
  return (0, _formula.createFormulaColumn)(currentMetric.value, {
    series,
    metric: currentMetric,
    dataView
  });
};
exports.convertStaticValueToFormulaColumn = convertStaticValueToFormulaColumn;