"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigurationForMetric = exports.getConfigurationForGauge = void 0;
var _color = _interopRequireDefault(require("color"));
var _palette = require("../palette");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getConfigurationForMetric = (model, layer, bucket) => {
  var _model$background_col, _primaryMetricWithCol;
  const [primarySeries, secondarySeries] = model.series.filter(({
    hidden
  }) => !hidden);
  const primaryMetricWithCollapseFn = (0, _utils.getMetricWithCollapseFn)(primarySeries);
  if (!primaryMetricWithCollapseFn || !primaryMetricWithCollapseFn.metric) {
    return null;
  }
  const secondaryMetricWithCollapseFn = (0, _utils.getMetricWithCollapseFn)(secondarySeries);
  const primaryColumn = (0, _utils.findMetricColumn)(primaryMetricWithCollapseFn.metric, layer.columns);
  const secondaryColumn = (0, _utils.findMetricColumn)(secondaryMetricWithCollapseFn === null || secondaryMetricWithCollapseFn === void 0 ? void 0 : secondaryMetricWithCollapseFn.metric, layer.columns);
  if (primaryMetricWithCollapseFn.collapseFn && secondaryMetricWithCollapseFn !== null && secondaryMetricWithCollapseFn !== void 0 && secondaryMetricWithCollapseFn.collapseFn) {
    return null;
  }
  const palette = (0, _palette.getPalette)((_model$background_col = model.background_color_rules) !== null && _model$background_col !== void 0 ? _model$background_col : []);
  if (palette === null) {
    return null;
  }
  return {
    layerId: layer.layerId,
    layerType: 'data',
    metricAccessor: primaryColumn === null || primaryColumn === void 0 ? void 0 : primaryColumn.columnId,
    secondaryMetricAccessor: secondaryColumn === null || secondaryColumn === void 0 ? void 0 : secondaryColumn.columnId,
    breakdownByAccessor: bucket === null || bucket === void 0 ? void 0 : bucket.columnId,
    palette,
    collapseFn: (_primaryMetricWithCol = primaryMetricWithCollapseFn.collapseFn) !== null && _primaryMetricWithCol !== void 0 ? _primaryMetricWithCol : secondaryMetricWithCollapseFn === null || secondaryMetricWithCollapseFn === void 0 ? void 0 : secondaryMetricWithCollapseFn.collapseFn
  };
};
exports.getConfigurationForMetric = getConfigurationForMetric;
const getConfigurationForGauge = (model, layer, bucket, gaugeMaxColumn) => {
  var _model$gauge_color_ru;
  const primarySeries = model.series[0];
  const primaryMetricWithCollapseFn = (0, _utils.getMetricWithCollapseFn)(primarySeries);
  if (!primaryMetricWithCollapseFn || !primaryMetricWithCollapseFn.metric) {
    return null;
  }
  const primaryColumn = (0, _utils.findMetricColumn)(primaryMetricWithCollapseFn.metric, layer.columns);
  const primaryColor = primarySeries.color ? (0, _color.default)(primarySeries.color).hex() : undefined;
  const gaugePalette = (0, _palette.getPalette)((_model$gauge_color_ru = model.gauge_color_rules) !== null && _model$gauge_color_ru !== void 0 ? _model$gauge_color_ru : [], primaryColor);
  if (gaugePalette === null) {
    return null;
  }
  return {
    layerId: layer.layerId,
    layerType: 'data',
    metricAccessor: primaryColumn === null || primaryColumn === void 0 ? void 0 : primaryColumn.columnId,
    breakdownByAccessor: bucket === null || bucket === void 0 ? void 0 : bucket.columnId,
    maxAccessor: gaugeMaxColumn === null || gaugeMaxColumn === void 0 ? void 0 : gaugeMaxColumn.columnId,
    showBar: Boolean(gaugeMaxColumn),
    palette: gaugePalette,
    collapseFn: primaryMetricWithCollapseFn.collapseFn,
    ...(gaugePalette ? {} : {
      color: primaryColor
    })
  };
};
exports.getConfigurationForGauge = getConfigurationForGauge;