"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AreaSeriesDecorator = AreaSeriesDecorator;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _series_styles = require("../utils/series_styles");
var _charts2 = require("../model/charts");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function AreaSeriesDecorator({
  seriesId,
  seriesGroupId,
  name,
  data,
  hideInLegend,
  lines,
  color,
  stackAccessors,
  stackMode,
  points,
  xScaleType,
  yScaleType,
  timeZone,
  enableHistogramMode,
  sortIndex,
  y1AccessorFormat,
  y0AccessorFormat,
  tickFormat
}) {
  const id = seriesId;
  const groupId = seriesGroupId;
  const areaSeriesStyle = (0, _series_styles.getAreaStyles)({
    points,
    lines,
    color
  });
  const seriesSettings = {
    id,
    name,
    groupId,
    data,
    color,
    hideInLegend,
    xAccessor: _constants.X_ACCESSOR_INDEX,
    yAccessors: _constants.Y_ACCESSOR_INDEXES,
    y0Accessors: lines.mode === 'band' ? _constants.Y0_ACCESSOR_INDEXES : undefined,
    y1AccessorFormat,
    y0AccessorFormat,
    stackAccessors,
    stackMode,
    xScaleType,
    yScaleType,
    timeZone,
    enableHistogramMode,
    sortIndex,
    tickFormat,
    ...areaSeriesStyle
  };
  if (enableHistogramMode) {
    seriesSettings.histogramModeAlignment = 'center';
  }
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, seriesSettings);
}
AreaSeriesDecorator.propTypes = _charts2.ChartsEntities.AreaChart;
AreaSeriesDecorator.defaultProps = {
  yScaleType: _charts.ScaleType.Linear,
  xScaleType: _charts.ScaleType.Time
};