"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GaugeVis = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _calculate_coordinates = require("../lib/calculate_coordinates");
var _chart = require("../constants/chart");
var _last_value_utils = require("../../../../common/last_value_utils");
var _render_counter = require("../../components/render_counter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class GaugeVis extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      scale: 1,
      top: 0,
      left: 0,
      translateX: 1,
      translateY: 1,
      resized: false
    };
    this.handleResize = this.handleResize.bind(this);
    this.checkResizeThrottled = _lodash.default.throttle(() => {
      const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
      if (newState && this.state && !_lodash.default.isEqual(newState, this.state)) {
        this.handleResize();
      }
    }, 200);
  }
  componentWillUnmount() {
    clearTimeout(this.timeout);
  }
  componentDidMount() {
    this.handleResize();
  }
  handleResize() {
    // Bingo!
    this.setState({
      ...(0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state),
      resized: true
    });
  }
  render() {
    const {
      type,
      value,
      max,
      color,
      initialRender
    } = this.props;

    // if value is empty array, no metrics to display.
    const formattedValue = (0, _last_value_utils.isEmptyValue)(value) ? 1 : value;
    const {
      scale,
      translateX,
      translateY,
      resized
    } = this.state;
    const size = 2 * Math.PI * 50;
    const sliceSize = type === 'half' ? 0.6 : 1;
    const percent = formattedValue < max ? formattedValue / max : 1;
    const resizeCSS = (0, _react2.css)`
      position: relative;
      display: flex;
      rowdirection: column;
      flex: 1 0 auto;
      overflow: hidden;
    `;
    const svgCSS = (0, _react2.css)`
      position: absolute;
      top: ${this.state.top || 0}px;
      left: ${this.state.left || 0}px;
      transform: matrix(${scale}, 0, 0, ${scale}, ${translateX}, ${translateY});
    `;
    const props = {
      circle: {
        r: 50,
        cx: 60,
        cy: 60,
        fill: 'rgba(0,0,0,0)',
        stroke: color,
        strokeWidth: this.props.gaugeLine,
        strokeDasharray: `${percent * sliceSize * size} ${size}`,
        transform: 'rotate(-90 60 60)'
      },
      circleBackground: {
        r: 50,
        cx: 60,
        cy: 60,
        fill: 'rgba(0,0,0,0)',
        stroke: _chart.COLORS.LINE_COLOR,
        strokeDasharray: `${sliceSize * size} ${size}`,
        strokeWidth: this.props.innerLine
      }
    };
    if (type === 'half') {
      props.circle.transform = 'rotate(-197.8 60 60)';
      props.circleBackground.transform = 'rotate(162 60 60)';
    }
    if (this.props.innerColor) {
      props.circleBackground.stroke = this.props.innerColor;
    }
    const svg = /*#__PURE__*/_react.default.createElement("svg", {
      width: 120.72,
      height: type === 'half' ? 78.72 : 120.72
    }, /*#__PURE__*/_react.default.createElement("circle", (0, _extends2.default)({}, props.circleBackground, {
      "data-test-subj": "gaugeCircleInner"
    })), /*#__PURE__*/_react.default.createElement("circle", (0, _extends2.default)({}, props.circle, {
      "data-test-subj": "gaugeCircle"
    })));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
      onResize: this.checkResizeThrottled
    }, resizeRef => /*#__PURE__*/_react.default.createElement(_render_counter.RenderCounter, {
      initialRender: initialRender,
      postponeExecution: !resized
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => {
        this.resize = el;
        resizeRef(el);
      },
      css: resizeCSS
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: svgCSS,
      ref: el => this.inner = el
    }, svg))));
  }
}
exports.GaugeVis = GaugeVis;
GaugeVis.defaultProps = {
  innerLine: 2,
  gaugeLine: 10
};
GaugeVis.propTypes = {
  color: _propTypes.default.string,
  gaugeLine: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  innerColor: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  innerLine: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  max: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  metric: _propTypes.default.object,
  reversed: _propTypes.default.bool,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.array]),
  type: _propTypes.default.oneOf(['half', 'circle'])
};