"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Gauge = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _set_is_reversed = require("../../lib/set_is_reversed");
var _last_value_utils = require("../../../../common/last_value_utils");
var _get_value_by = require("../lib/get_value_by");
var _gauge_vis = require("./gauge_vis");
var _calculate_coordinates = require("../lib/calculate_coordinates");
require("./_gauge.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Gauge extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handledResize", false);
    this.state = {
      scale: 1,
      top: 0,
      left: 0,
      translateX: 1,
      translateY: 1
    };
    this.handleResize = this.handleResize.bind(this);
    this.checkResizeThrottled = _lodash.default.throttle(() => {
      const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
      if (newState && this.state && !_lodash.default.isEqual(newState, this.state)) {
        this.handleResize();
      }
    }, 200);
  }
  componentWillUnmount() {
    clearTimeout(this.timeout);
  }
  componentDidMount() {
    this.handleResize(true);
  }
  handleResize() {
    // Bingo!
    const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
    this.setState(newState);
    this.handledResize = true;
  }
  render() {
    const {
      metric,
      type,
      initialRender
    } = this.props;
    const {
      scale,
      translateX,
      translateY
    } = this.state;
    const value = (0, _last_value_utils.getLastValue)(metric === null || metric === void 0 ? void 0 : metric.data);
    const max = metric && (0, _get_value_by.getValueBy)('max', metric.data) || 1;
    const formatter = metric && (metric.tickFormatter || metric.formatter) || this.props.tickFormatter || (v => v);
    const title = metric && metric.label || '';
    const innerCSS = (0, _react2.css)`
      top: ${this.state.top || 0}px;
      left: ${this.state.left || 0}px;
      transform: matrix(${scale}, 0, 0, ${scale}, ${translateX}, ${translateY});
      z-index: 1;
    `;
    const gaugeProps = {
      value,
      reversed: (0, _set_is_reversed.isBackgroundDark)(this.props.backgroundColor),
      gaugeLine: this.props.gaugeLine,
      innerLine: this.props.innerLine,
      innerColor: this.props.innerColor,
      max: this.props.max || max,
      color: metric && metric.color || '#8ac336',
      type,
      initialRender
    };
    let metrics;
    let additionalLabel;
    if (this.props.additionalLabel) {
      additionalLabel = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__additionalLabel"
      }, this.props.additionalLabel);
    }
    if (type === 'half') {
      metrics = /*#__PURE__*/_react.default.createElement("div", {
        css: innerCSS,
        className: "tvbVisHalfGauge__metrics",
        ref: el => this.inner = el
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__label",
        ref: "title",
        "data-test-subj": "gaugeLabel"
      }, title), /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__value",
        style: this.props.valueColor ? {
          color: this.props.valueColor
        } : {},
        ref: "label",
        "data-test-subj": "gaugeValue"
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: formatter(value)
        }
      })), additionalLabel);
    } else {
      metrics = /*#__PURE__*/_react.default.createElement("div", {
        css: innerCSS,
        className: "tvbVisCircleGauge__metrics",
        ref: el => this.inner = el
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__value",
        style: this.props.valueColor ? {
          color: this.props.valueColor
        } : {},
        ref: "label",
        "data-test-subj": "gaugeValue"
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: formatter(value)
        }
      })), /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__label",
        ref: "title",
        "data-test-subj": "gaugeLabel"
      }, title), additionalLabel);
    }
    const classes = (0, _classnames.default)({
      tvbVisHalfGauge: type === 'half',
      tvbVisCircleGauge: type === 'circle',
      'tvbVisGauge--reversed': (0, _set_is_reversed.isBackgroundInverted)(this.props.backgroundColor)
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
      onResize: this.checkResizeThrottled
    }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
      className: classes,
      ref: resizeRef
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => this.resize = el,
      className: `tvbVisGauge__resize`,
      "data-test-subj": "tvbVisGaugeContainer"
    }, metrics, /*#__PURE__*/_react.default.createElement(_gauge_vis.GaugeVis, gaugeProps))));
  }
}
exports.Gauge = Gauge;
Gauge.defaultProps = {
  type: 'half',
  innerLine: 2,
  gaugeLine: 10
};
Gauge.propTypes = {
  gaugeLine: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  innerColor: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  innerLine: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  max: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  metric: _propTypes.default.object,
  backgroundColor: _propTypes.default.string,
  type: _propTypes.default.oneOf(['half', 'circle']),
  valueColor: _propTypes.default.string,
  additionalLabel: _propTypes.default.string
};