"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TSVB_EDITOR_NAME = exports.EditorController = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../services");
var _vis_editor_lazy = require("./components/vis_editor_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TSVB_EDITOR_NAME = 'tsvbEditor';
exports.TSVB_EDITOR_NAME = TSVB_EDITOR_NAME;
class EditorController {
  constructor(el, vis, eventEmitter, embeddableHandler) {
    this.el = el;
    this.vis = vis;
    this.eventEmitter = eventEmitter;
    this.embeddableHandler = embeddableHandler;
  }
  async render({
    timeRange,
    uiState,
    filters,
    query
  }) {
    const I18nContext = (0, _services.getI18n)().Context;
    const defaultIndexPattern = (await (0, _services.getDataViewsStart)().getDefault()) || undefined;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: (0, _services.getCoreStart)().theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_vis_editor_lazy.VisEditor, {
      config: (0, _services.getUISettings)(),
      vis: this.vis,
      timeRange: timeRange,
      embeddableHandler: this.embeddableHandler,
      eventEmitter: this.eventEmitter,
      uiState: uiState,
      filters: filters,
      query: query,
      defaultIndexPattern: defaultIndexPattern
    }))), this.el);
  }
  destroy() {
    (0, _reactDom.unmountComponentAtNode)(this.el);
  }
}
exports.EditorController = EditorController;