"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastValueModePopover = void 0;
require("./last_value_mode_popover.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LastValueModePopover = ({
  isIndicatorDisplayed,
  toggleIndicatorDisplay
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    className: "tvbLastValueModePopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: 'gear',
      onClick: onButtonClick,
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.gearButton', {
        defaultMessage: 'Change last value indicator display option'
      })
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbLastValueModePopoverBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.title', {
    defaultMessage: 'Last value options'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: isIndicatorDisplayed,
    label: _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.switch', {
      defaultMessage: 'Show label when using Last value mode'
    }),
    onChange: toggleIndicatorDisplay
  })));
};
exports.LastValueModePopover = LastValueModePopover;