"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastValueModeIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _get_interval = require("./lib/get_interval");
var _create_interval_based_formatter = require("./lib/create_interval_based_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const lastValueLabel = _i18n.i18n.translate('visTypeTimeseries.lastValueModeIndicator.lastValue', {
  defaultMessage: 'Last value'
});
const LastValueModeIndicator = ({
  seriesData,
  panelInterval,
  modelInterval,
  ignoreDaylightTime
}) => {
  if (!(seriesData !== null && seriesData !== void 0 && seriesData.length)) return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, lastValueLabel);
  const dateFormat = (0, _services.getUISettings)().get('dateFormat');
  const scaledDataFormat = (0, _services.getUISettings)().get('dateFormat:scaled');
  const getFormattedPanelInterval = () => {
    const interval = (0, _get_interval.convertIntervalIntoUnit)(panelInterval, false);
    return interval && `${interval.unitValue}${interval.unitString}`;
  };
  const formatter = (0, _create_interval_based_formatter.createIntervalBasedFormatter)(panelInterval, scaledDataFormat, dateFormat, ignoreDaylightTime);
  const lastBucketDate = formatter(seriesData[seriesData.length - 1][0]);
  const formattedPanelInterval = ((0, _get_interval.isAutoInterval)(modelInterval) || (0, _get_interval.isGteInterval)(modelInterval)) && getFormattedPanelInterval();
  const tooltipContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.lastValueModeIndicator.lastBucketDate",
    defaultMessage: "Bucket: {lastBucketDate}",
    values: {
      lastBucketDate
    }
  })), formattedPanelInterval && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.lastValueModeIndicator.panelInterval",
    defaultMessage: "Interval: {formattedPanelInterval}",
    values: {
      formattedPanelInterval
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    display: "inlineBlock",
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "iInCircle",
    iconSide: "right",
    onClick: () => {},
    onClickAriaLabel: _i18n.i18n.translate('visTypeTimeseries.lastValueModeIndicator.lastValueModeBadgeAriaLabel', {
      defaultMessage: 'View last value details'
    })
  }, lastValueLabel));
};
exports.LastValueModeIndicator = LastValueModeIndicator;