"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorComponent = ErrorComponent;
var _eui = require("@elastic/eui");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18nReact = require("@kbn/i18n-react");
require("./_error.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const guidPattern = /\[[[a-f\d-\\]{36}\]/g;
function ErrorComponent(props) {
  const {
    error
  } = props;
  let additionalInfo;
  const type = _lodash.default.get(error, 'error.caused_by.type') || _lodash.default.get(error, 'error.type');
  let reason = _lodash.default.get(error, 'error.caused_by.reason');
  const title = _lodash.default.get(error, 'error.caused_by.title');
  if (!reason) {
    reason = _lodash.default.get(error, 'message');
  }
  if (['runtime_exception', 'illegal_argument_exception'].includes(type)) {
    reason = _lodash.default.get(error, 'error.reason').replace(guidPattern, ``);
  }
  if (type === 'script_exception') {
    const scriptStack = _lodash.default.get(error, 'error.caused_by.script_stack');
    reason = _lodash.default.get(error, 'error.caused_by.caused_by.reason');
    additionalInfo = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbError__additional"
    }, /*#__PURE__*/_react.default.createElement("div", null, reason), /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbError__stack"
    }, scriptStack.join('\n')));
  } else if (reason) {
    additionalInfo = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbError__additional"
    }, reason);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    size: "m",
    color: "danger",
    "aria-hidden": "true"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), title || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.error.requestForPanelFailedErrorMessage",
    defaultMessage: "The request for this panel failed"
  }), additionalInfo));
}
ErrorComponent.propTypes = {
  error: _propTypes.default.object
};