"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileHdr = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PercentileHdr = ({
  value,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.percentileHdr.numberOfSignificantValueDigits",
    defaultMessage: "Number of significant value digits (HDR histogram)"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.percentileHdr.numberOfSignificantValueDigits.hint",
      defaultMessage: "HDR Histogram (High Dynamic Range Histogram) is an alternative implementation that can be useful when calculating percentile ranks for latency measurements as it can be faster than the t-digest implementation with the trade-off of a larger memory footprint. Number of significant value digits parameter specifies the resolution of values for the histogram in number of significant digits"
    }),
    type: "questionInCircle"
  }))
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
  min: 1,
  value: value || '',
  onChange: onChange
}));
exports.PercentileHdr = PercentileHdr;