"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelectItem = FieldSelectItem;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _add_delete_buttons = require("../../add_delete_buttons");
var _field_select_utils = require("./field_select_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultPlaceholder = _i18n.i18n.translate('visTypeTimeseries.fieldSelect.selectFieldPlaceholder', {
  defaultMessage: 'Select field...'
});
function FieldSelectItem({
  options,
  selectedOptions,
  placeholder = defaultPlaceholder,
  disabled,
  disableAdd,
  disableDelete,
  onChange,
  onDeleteItem,
  onNewItemAdd
}) {
  const isInvalid = Boolean(selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.find(item => item.id === _field_select_utils.INVALID_FIELD_ID));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: placeholder,
    isDisabled: disabled,
    options: options,
    selectedOptions: selectedOptions,
    onChange: onChange,
    singleSelection: {
      asPlainText: true
    },
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": "fieldSelectItem"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    onAdd: onNewItemAdd,
    onDelete: onDeleteItem,
    disableDelete: disableDelete,
    disableAdd: disableAdd,
    responsive: false,
    testSubj: "fieldSelectItem"
  })));
}