"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableVisRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const TableVisualizationComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/table_visualization'))));

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const getTableVisRenderer = (core, usageCollection) => ({
  name: 'table_vis',
  reuseDomNode: true,
  render: async (domNode, {
    visData,
    visConfig,
    canNavigateToLens
  }, handlers) => {
    var _visData$table;
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const showNoResult = ((_visData$table = visData.table) === null || _visData$table === void 0 ? void 0 : _visData$table.rows.length) === 0 || !visData.table && visData.tables.length === 0;
    const renderCompete = () => {
      const containerType = extractContainerType(handlers.getExecutionContext());
      const visualizationType = 'agg_based';
      if (containerType) {
        const counterEvents = [`render_${visualizationType}_table`, !visData.table ? `render_${visualizationType}_table_split` : undefined, canNavigateToLens ? `render_${visualizationType}_table_convertable` : undefined].filter(Boolean);
        usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, counterEvents);
      }
      handlers.done();
    };
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
      "data-test-subj": "tbvChartContainer",
      handlers: handlers,
      renderComplete: renderCompete,
      showNoResult: showNoResult
    }, /*#__PURE__*/_react.default.createElement(TableVisualizationComponent, {
      core: core,
      handlers: handlers,
      visData: visData,
      visConfig: visConfig,
      renderComplete: renderCompete
    }))), domNode);
  }
});
exports.getTableVisRenderer = getTableVisRenderer;