"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/charts-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _components = require("./components");
var _to_ast = require("./to_ast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const createMetricVisTypeDefinition = () => ({
  name: 'metric',
  title: _i18n.i18n.translate('visTypeMetric.metricTitle', {
    defaultMessage: 'Metric'
  }),
  icon: 'visMetric',
  description: _i18n.i18n.translate('visTypeMetric.metricDescription', {
    defaultMessage: 'Show a calculation as a single number.'
  }),
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      addTooltip: true,
      addLegend: false,
      type: 'metric',
      metric: {
        percentageMode: false,
        useRanges: false,
        colorSchema: _public.ColorSchemas.GreenToRed,
        metricColorMode: _public.ColorMode.None,
        colorsRange: [{
          from: 0,
          to: 10000
        }],
        labels: {
          show: true
        },
        invertColors: false,
        style: {
          bgFill: '#000',
          bgColor: false,
          labelColor: false,
          subText: '',
          fontSize: 60
        }
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: _components.MetricVisOptions,
    schemas: [{
      group: _public2.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeMetric.schemas.metricTitle', {
        defaultMessage: 'Metric'
      }),
      min: 1,
      aggFilter: ['!std_dev', '!geo_centroid', '!derivative', '!serial_diff', '!moving_avg', '!cumulative_sum', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      aggSettings: {
        top_hits: {
          allowStrings: true
        }
      },
      defaults: [{
        type: 'count',
        schema: 'metric'
      }]
    }, {
      group: _public2.AggGroupNames.Buckets,
      name: 'group',
      title: _i18n.i18n.translate('visTypeMetric.schemas.splitGroupTitle', {
        defaultMessage: 'Split group'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return vis ? convertToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
    };
  }
});
exports.createMetricVisTypeDefinition = createMetricVisTypeDefinition;