"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStopsWithColorsFromRanges = exports.getStopsWithColorsFromColorsNumber = void 0;
var _common = require("@kbn/charts-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TRANSPARENT = 'rgba(0, 0, 0, 0)';
const getColor = (index, elementsCount, colorSchema, invertColors = false) => {
  const value = invertColors ? 1 - index / elementsCount : index / elementsCount;
  return (0, _common.getHeatmapColors)(value, colorSchema);
};
const getStopsWithColorsFromColorsNumber = (colorsNumber, colorSchema, invertColors = false, includeZeroElement = false) => {
  const colors = [];
  const stops = [];
  if (!colorsNumber) {
    return {
      color: []
    };
  }
  if (includeZeroElement) {
    colors.push(TRANSPARENT);
    stops.push(0);
  }
  const step = 100 / colorsNumber;
  for (let i = 0; i < colorsNumber; i++) {
    colors.push(getColor(i, colorsNumber, colorSchema, invertColors));
    stops.push(step + i * step);
  }
  return {
    color: colors !== null && colors !== void 0 ? colors : [],
    stop: stops !== null && stops !== void 0 ? stops : []
  };
};
exports.getStopsWithColorsFromColorsNumber = getStopsWithColorsFromColorsNumber;
const getStopsWithColorsFromRanges = (ranges, colorSchema, invertColors = false) => {
  return ranges.reduce((acc, range, index, rangesArr) => {
    if (index && range.from !== rangesArr[index - 1].to) {
      acc.color.push(TRANSPARENT);
      acc.stop.push(range.from);
    }
    acc.color.push(getColor(index, rangesArr.length, colorSchema, invertColors));
    acc.stop.push(range.to);
    return acc;
  }, {
    color: [],
    stop: []
  });
};
exports.getStopsWithColorsFromRanges = getStopsWithColorsFromRanges;