"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorNavBar = DefaultEditorNavBar;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DefaultEditorNavBar({
  setSelectedTab,
  optionTabs
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    className: "visEditorSidebar__nav",
    size: "s"
  }, optionTabs.map(({
    name,
    title,
    isSelected = false
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: name,
    isSelected: isSelected,
    "data-test-subj": `visEditorTab__${name}`,
    onClick: () => setSelectedTab(name)
  }, title)));
}