"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequiredNumberInputOption = RequiredNumberInputOption;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Use only this component instead of NumberInputOption in 'number_input.tsx'.
 * It is required for compatibility with TS 3.7.0
 *
 * @param {number} props.value Should be numeric only
 */
function RequiredNumberInputOption({
  disabled,
  error,
  isInvalid,
  label,
  max,
  min,
  paramName,
  step,
  value,
  setValue,
  setValidity,
  'data-test-subj': dataTestSubj
}) {
  const isValid = value !== null;
  (0, _react.useEffect)(() => {
    setValidity(paramName, isValid);
    return () => setValidity(paramName, true);
  }, [isValid, paramName, setValidity]);
  const onChange = (0, _react.useCallback)(ev => setValue(paramName, isNaN(ev.target.valueAsNumber) ? null : ev.target.valueAsNumber), [setValue, paramName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    error: error,
    isInvalid: isInvalid,
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    fullWidth: true,
    required: true,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    isInvalid: !isValid,
    step: step,
    max: max,
    min: min,
    value: value === null ? '' : value,
    onChange: onChange
  }));
}