"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScaleMetricsParamEditor = ScaleMetricsParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _switch = require("./switch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ScaleMetricsParamEditor(props) {
  return /*#__PURE__*/_react.default.createElement(_switch.SwitchParamEditor, (0, _extends2.default)({
    dataTestSubj: "scaleMetricsSwitch",
    displayLabel: _i18n.i18n.translate('visDefaultEditor.controls.scaleMetricsLabel', {
      defaultMessage: 'Scale metric values (deprecated)'
    }),
    displayToolTip: _i18n.i18n.translate('visDefaultEditor.controls.scaleMetricsTooltip', {
      defaultMessage: 'If you select a manual minimum interval and a larger interval will be used, enabling this will ' + 'cause count and sum metrics to be scaled to the manual selected interval.'
    })
  }, props));
}