"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleNumberList = SimpleNumberList;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./number_list/utils");
var _number_row = require("./number_list/number_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const generateId = (0, _eui.htmlIdGenerator)();
function SimpleNumberList({
  agg,
  aggParam,
  value,
  setValue,
  setTouched
}) {
  const [numbers, setNumbers] = (0, _react.useState)((0, _utils.getInitModelList)(value && (0, _lodash.isArray)(value) ? value : [_utils.EMPTY_STRING]));
  const numberRange = (0, _react.useMemo)(() => (0, _utils.getRange)('[-Infinity,Infinity]'), []);

  // This useEffect is needed to discard changes, it sets numbers a mapped value if they are different
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isArray)(value) && (value.length !== numbers.length || !value.every((numberValue, index) => numberValue === numbers[index].value))) {
      setNumbers(value.map(numberValue => ({
        id: generateId(),
        value: numberValue,
        isInvalid: false
      })));
    }
  }, [numbers, value]);
  const onUpdate = (0, _react.useCallback)(numberList => {
    setNumbers(numberList);
    setValue(numberList.map(({
      value: numberValue
    }) => numberValue));
  }, [setValue]);
  const onChangeValue = (0, _react.useCallback)(numberField => {
    onUpdate(numbers.map(number => number.id === numberField.id ? {
      id: numberField.id,
      value: (0, _utils.parse)(numberField.value),
      isInvalid: false
    } : number));
  }, [numbers, onUpdate]);

  // Add an item to the end of the list
  const onAdd = (0, _react.useCallback)(() => {
    const newArray = [...numbers, {
      id: generateId(),
      value: _utils.EMPTY_STRING,
      isInvalid: false
    }];
    onUpdate(newArray);
  }, [numbers, onUpdate]);
  const onDelete = (0, _react.useCallback)(id => onUpdate(numbers.filter(number => number.id !== id)), [numbers, onUpdate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: `${aggParam.name}-${agg.id}}`,
    label: aggParam.displayName || aggParam.name,
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, numbers.map((number, arrayIndex) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: number.id
  }, /*#__PURE__*/_react.default.createElement(_number_row.NumberRow, {
    isInvalid: number.isInvalid,
    disableDelete: numbers.length === 1,
    model: number,
    labelledbyId: `${aggParam.name}-${agg.id}-legend`,
    range: numberRange,
    onDelete: onDelete,
    onChange: onChangeValue,
    onBlur: setTouched,
    autoFocus: numbers.length !== 1 && arrayIndex === numbers.length - 1
  }), numbers.length - 1 !== arrayIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.includeExclude.addUnitButtonLabel",
    defaultMessage: "Add value"
  })))));
}