"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberRow = NumberRow;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function NumberRow({
  autoFocus,
  disableDelete,
  model,
  isInvalid,
  labelledbyId,
  range,
  onBlur,
  onDelete,
  onChange
}) {
  const deleteBtnAriaLabel = _i18n.i18n.translate('visDefaultEditor.controls.numberList.removeUnitButtonAriaLabel', {
    defaultMessage: 'Remove the rank value of {value}',
    values: {
      value: model.value
    }
  });
  const onValueChanged = (0, _react.useCallback)(event => onChange({
    value: event.target.value,
    id: model.id
  }), [onChange, model.id]);
  const onDeleteFn = (0, _react.useCallback)(() => onDelete(model.id), [onDelete, model.id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-labelledby": labelledbyId,
    autoFocus: autoFocus,
    compressed: true,
    isInvalid: isInvalid,
    placeholder: _i18n.i18n.translate('visDefaultEditor.controls.numberList.enterValuePlaceholder', {
      defaultMessage: 'Enter a value'
    }),
    onChange: onValueChanged,
    value: model.value,
    fullWidth: true,
    min: range.min,
    max: range.max,
    onBlur: onBlur
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": deleteBtnAriaLabel,
    title: deleteBtnAriaLabel,
    color: "danger",
    iconType: "trash",
    onClick: onDeleteFn,
    disabled: disableDelete
  })));
}