"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveUrlParams = resolveUrlParams;
var _public = require("@kbn/observability-plugin/public");
var _ux_ui_filter = require("../../../common/ux_ui_filter");
var _pick_keys = require("../../../common/utils/pick_keys");
var _helpers = require("./helpers");
var _environment_filter_values = require("../../../common/environment_filter_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function resolveUrlParams(location, state) {
  const query = (0, _public.toQuery)(location.search);
  const {
    page,
    pageSize,
    sortDirection,
    sortField,
    refreshPaused,
    refreshInterval,
    rangeFrom,
    rangeTo,
    environment,
    searchTerm,
    percentile
  } = query;
  const localUIFilters = (0, _pick_keys.pickKeys)(query, ..._ux_ui_filter.uxLocalUIFilterNames);
  return (0, _helpers.removeUndefinedProps)({
    // date params
    ...(0, _helpers.getDateRange)({
      state,
      rangeFrom,
      rangeTo
    }),
    rangeFrom,
    rangeTo,
    refreshPaused: refreshPaused ? (0, _helpers.toBoolean)(refreshPaused) : undefined,
    refreshInterval: refreshInterval ? (0, _helpers.toNumber)(refreshInterval) : undefined,
    // query params
    environment: (0, _helpers.toString)(environment) || _environment_filter_values.ENVIRONMENT_ALL.value,
    sortDirection,
    sortField,
    page: (0, _helpers.toNumber)(page) || 0,
    pageSize: pageSize ? (0, _helpers.toNumber)(pageSize) : undefined,
    searchTerm: (0, _helpers.toString)(searchTerm),
    percentile: (0, _helpers.toNumber)(percentile),
    ...localUIFilters
  });
}