"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDateRange = getDateRange;
exports.getExactDate = getExactDate;
exports.getPathAsArray = getPathAsArray;
exports.removeUndefinedProps = removeUndefinedProps;
exports.toBoolean = toBoolean;
exports.toNumber = toNumber;
exports.toString = toString;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getParsedDate(rawDate, options = {}) {
  if (rawDate) {
    const parsed = _datemath.default.parse(rawDate, options);
    if (parsed && parsed.isValid()) {
      return parsed.toDate();
    }
  }
}
function getExactDate(rawDate) {
  const isRelativeDate = rawDate.startsWith('now');
  if (isRelativeDate) {
    // remove rounding from relative dates "Today" (now/d) and "This week" (now/w)
    const rawDateWithouRounding = rawDate.replace(/\/([smhdw])$/, '');
    return getParsedDate(rawDateWithouRounding);
  }
  return getParsedDate(rawDate);
}
function getDateRange({
  state = {},
  rangeFrom,
  rangeTo
}) {
  // If the previous state had the same range, just return that instead of calculating a new range.
  if (state.rangeFrom === rangeFrom && state.rangeTo === rangeTo) {
    return {
      start: state.start,
      end: state.end,
      exactStart: state.exactStart,
      exactEnd: state.exactEnd
    };
  }
  const start = getParsedDate(rangeFrom);
  const end = getParsedDate(rangeTo, {
    roundUp: true
  });
  const exactStart = rangeFrom ? getExactDate(rangeFrom) : undefined;
  const exactEnd = rangeTo ? getExactDate(rangeTo) : undefined;

  // `getParsedDate` will return undefined for invalid or empty dates. We return
  // the previous state if either date is undefined.
  if (!start || !end) {
    return {
      start: state.start,
      end: state.end,
      exactStart: state.exactStart,
      exactEnd: state.exactEnd
    };
  }

  // rounds down start to minute
  const roundedStart = (0, _moment.default)(start).startOf('minute');
  return {
    start: roundedStart.toISOString(),
    end: end.toISOString(),
    exactStart: exactStart === null || exactStart === void 0 ? void 0 : exactStart.toISOString(),
    exactEnd: exactEnd === null || exactEnd === void 0 ? void 0 : exactEnd.toISOString()
  };
}
function toNumber(value) {
  if (value !== undefined) {
    return parseInt(value, 10);
  }
}
function toString(value) {
  if (value === '' || value === 'null' || value === 'undefined') {
    return;
  }
  return value;
}
function toBoolean(value) {
  return value === 'true';
}
function getPathAsArray(pathname = '') {
  return (0, _lodash.compact)(pathname.split('/'));
}
function removeUndefinedProps(obj) {
  return (0, _lodash.pickBy)(obj, value => value !== undefined);
}