"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyUXMetrics = KeyUXMetrics;
exports.formatToSec = formatToSec;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _use_long_task_metrics_query = require("../../../../hooks/use_long_task_metrics_query");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatToSec(value, fromUnit = 'MicroSec') {
  const valueInMs = Number(value !== null && value !== void 0 ? value : 0) / (fromUnit === 'MicroSec' ? 1000 : 1);
  if (valueInMs < 1000) {
    return valueInMs.toFixed(0) + ' ms';
  }
  return (valueInMs / 1000).toFixed(2) + ' s';
}
const STAT_STYLE = {
  width: '200px'
};
function formatTitle(unit, value) {
  if (typeof value === 'undefined' || value === null) return _translations.DATA_UNDEFINED_LABEL;
  return formatToSec(value, unit);
}
function KeyUXMetrics({
  data,
  loading
}) {
  const {
    data: longTaskData,
    loading: loadingLongTask
  } = (0, _use_long_task_metrics_query.useLongTaskMetricsQuery)();

  // Note: FCP value is in ms unit
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: STAT_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "s",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : data.fcp),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.FCP_LABEL, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.FCP_TOOLTIP,
      type: "questionInCircle"
    })),
    isLoading: loading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: STAT_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "s",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : data.tbt),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.TBT_LABEL, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.TBT_TOOLTIP,
      type: "questionInCircle"
    })),
    isLoading: loading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: STAT_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "uxLongTaskCount",
    titleSize: "s",
    title: (longTaskData === null || longTaskData === void 0 ? void 0 : longTaskData.noOfLongTasks) !== undefined ? (0, _numeral.default)(longTaskData === null || longTaskData === void 0 ? void 0 : longTaskData.noOfLongTasks).format('0,0') : _translations.DATA_UNDEFINED_LABEL,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.NO_OF_LONG_TASK, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.NO_OF_LONG_TASK_TOOLTIP,
      type: "questionInCircle"
    })),
    isLoading: !!loadingLongTask
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: STAT_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "uxLongestTask",
    titleSize: "s",
    title: formatTitle('ms', longTaskData === null || longTaskData === void 0 ? void 0 : longTaskData.longestLongTask),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.LONGEST_LONG_TASK, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.LONGEST_LONG_TASK_TOOLTIP,
      type: "questionInCircle"
    })),
    isLoading: !!loadingLongTask
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: STAT_STYLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "uxSumLongTask",
    titleSize: "s",
    title: formatTitle('ms', longTaskData === null || longTaskData === void 0 ? void 0 : longTaskData.sumOfLongTasks),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.SUM_LONG_TASKS, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.SUM_LONG_TASKS_TOOLTIP,
      type: "questionInCircle"
    })),
    isLoading: !!loadingLongTask
  })));
}